/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.IntMath;
import org.apache.commons.statistics.descriptive.LongMean;
import org.apache.commons.statistics.descriptive.LongStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;
import org.apache.commons.statistics.descriptive.UInt192;

public final class LongVariance
implements LongStatistic,
StatisticAccumulator<LongVariance> {
    private final UInt192 sumSq;
    private final Int128 sum;
    private long n;
    private boolean biased;

    private LongVariance() {
        this(UInt192.create(), Int128.create(), 0);
    }

    private LongVariance(UInt192 sumSq, Int128 sum, int n) {
        this.sumSq = sumSq;
        this.sum = sum;
        this.n = n;
    }

    public static LongVariance create() {
        return new LongVariance();
    }

    public static LongVariance of(long ... values) {
        return LongVariance.createFromRange(values, 0, values.length);
    }

    public static LongVariance ofRange(long[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return LongVariance.createFromRange(values, from, to);
    }

    static LongVariance createFromRange(long[] values, int from, int to) {
        Int128 s = Int128.create();
        UInt192 ss = UInt192.create();
        for (int i = from; i < to; ++i) {
            long x = values[i];
            s.add(x);
            ss.addSquare(x);
        }
        return new LongVariance(ss, s, to - from);
    }

    @Override
    public void accept(long value) {
        this.sumSq.addSquare(value);
        this.sum.add(value);
        ++this.n;
    }

    @Override
    public double getAsDouble() {
        return LongVariance.computeVarianceOrStd(this.sumSq, this.sum, this.n, this.biased, false);
    }

    static double computeVarianceOrStd(UInt192 sumSq, Int128 sum, long n, boolean biased, boolean std) {
        if (n == 0L) {
            return Double.NaN;
        }
        if (n == 1L) {
            return 0.0;
        }
        double diff = LongVariance.computeSSDevN(sumSq, sum, n);
        long n0 = biased ? n : n - 1L;
        double v = diff / IntMath.unsignedMultiplyToDouble(n, n0);
        if (std) {
            return Math.sqrt(v);
        }
        return v;
    }

    private static double computeSSDevN(UInt192 sumSq, Int128 sum, long n) {
        if ((n >>> 32 | sum.hi64()) == 0L) {
            return sumSq.unsignedMultiply((int)n).subtract(sum.squareLow()).toDouble();
        }
        return sumSq.toBigInteger().multiply(BigInteger.valueOf(n)).subtract(LongVariance.square(sum.toBigInteger())).doubleValue();
    }

    double computeSumOfSquaredDeviations() {
        return LongVariance.computeSSDevN(this.sumSq, this.sum, this.n) / (double)this.n;
    }

    double computeMean() {
        return LongMean.computeMean(this.sum, this.n);
    }

    private static BigInteger square(BigInteger x) {
        return x.multiply(x);
    }

    @Override
    public LongVariance combine(LongVariance other) {
        this.sumSq.add(other.sumSq);
        this.sum.add(other.sum);
        this.n += other.n;
        return this;
    }

    public LongVariance setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

