/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.GroupMgr;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.GroupMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.GroupMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class GroupMgrFactory {
    private static final String CLS_NM = GroupMgrFactory.class.getName();

    private GroupMgrFactory() {
    }

    public static GroupMgr createInstance() throws SecurityException {
        return GroupMgrFactory.createInstance("HOME");
    }

    public static GroupMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String groupClassName = Config.getInstance().getProperty("groupmgr.implementation");
        Manageable groupMgr = null;
        groupMgr = StringUtils.isEmpty((CharSequence)groupClassName) ? (Config.getInstance().isRestEnabled() ? new GroupMgrRestImpl() : new GroupMgrImpl()) : (GroupMgr)ClassUtil.createInstance(groupClassName);
        groupMgr.setContextId(contextId);
        return groupMgr;
    }

    public static GroupMgr createInstance(Session adminSess) throws SecurityException {
        return GroupMgrFactory.createInstance("HOME", adminSess);
    }

    public static GroupMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        GroupMgr groupMgr = GroupMgrFactory.createInstance(contextId);
        groupMgr.setAdmin(adminSess);
        return groupMgr;
    }
}

