/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common;

import java.io.IOException;
import java.net.URL;
import java.util.PropertyResourceBundle;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.UiThreadEventRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.ValueEditorsPreferences;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BrowserCommonActivator
extends AbstractUIPlugin {
    private static BrowserCommonActivator plugin;
    private FontRegistry fontRegistry;
    private ColorRegistry colorRegistry;
    private ValueEditorsPreferences valueEditorPreferences;
    private ContributionTemplateStore filterTemplateStore;
    private ContributionContextTypeRegistry filterTemplateContextTypeRegistry;
    private EventRunner eventRunner;
    private PropertyResourceBundle properties;

    public BrowserCommonActivator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.eventRunner == null) {
            this.eventRunner = new UiThreadEventRunner();
        }
        if (this.fontRegistry == null) {
            this.fontRegistry = new FontRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        if (this.colorRegistry == null) {
            this.colorRegistry = new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        this.valueEditorPreferences = new ValueEditorsPreferences();
        if (this.filterTemplateContextTypeRegistry == null) {
            this.filterTemplateContextTypeRegistry = new ContributionContextTypeRegistry();
            this.filterTemplateContextTypeRegistry.addContextType(BrowserCommonConstants.FILTER_TEMPLATE_ID);
            this.filterTemplateContextTypeRegistry.getContextType(BrowserCommonConstants.FILTER_TEMPLATE_ID).addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        }
        if (this.filterTemplateStore == null) {
            this.filterTemplateStore = new ContributionTemplateStore(this.getFilterTemplateContextTypeRegistry(), this.getPreferenceStore(), "templates");
            try {
                this.filterTemplateStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (this.eventRunner != null) {
            this.eventRunner = null;
        }
        if (this.fontRegistry != null) {
            this.fontRegistry = null;
        }
        if (this.colorRegistry != null) {
            this.colorRegistry = null;
        }
        if (this.filterTemplateContextTypeRegistry != null) {
            this.filterTemplateContextTypeRegistry = null;
        }
        if (this.filterTemplateStore != null) {
            try {
                this.filterTemplateStore.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.filterTemplateStore = null;
        }
    }

    public static BrowserCommonActivator getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (key != null) {
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(key), null);
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
            return null;
        }
        return null;
    }

    public Image getImage(String key) {
        ImageDescriptor id;
        Image image = this.getImageRegistry().get(key);
        if (image == null && (id = this.getImageDescriptor(key)) != null) {
            image = id.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public Font getFont(FontData[] fontData) {
        if (!this.fontRegistry.hasValueFor(fontData[0].toString())) {
            this.fontRegistry.put(fontData[0].toString(), fontData);
        }
        return this.fontRegistry.get(fontData[0].toString());
    }

    public Color getColor(RGB rgb) {
        if (!this.colorRegistry.hasValueFor(rgb.toString())) {
            this.colorRegistry.put(rgb.toString(), rgb);
        }
        return this.colorRegistry.get(rgb.toString());
    }

    public ValueEditorsPreferences getValueEditorsPreferences() {
        return this.valueEditorPreferences;
    }

    public TemplateStore getFilterTemplateStore() {
        return this.filterTemplateStore;
    }

    public ContextTypeRegistry getFilterTemplateContextTypeRegistry() {
        return this.filterTemplateContextTypeRegistry;
    }

    public EventRunner getEventRunner() {
        return this.eventRunner;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.ldapbrowser.common", 0, "Unable to get the plugin properties.", (Throwable)e));
            }
        }
        return this.properties;
    }
}

