/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.exceptions;

import java.text.MessageFormat;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpireException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(EmpireException.class);
    private static ExceptionMessageFormatter messageFormatter = new ExceptionMessageFormatter();
    private final ErrorType errorType;
    private final String[] errorParams;

    public static ExceptionMessageFormatter getMessageFormatter() {
        return messageFormatter;
    }

    public static void setMessageFormatter(ExceptionMessageFormatter messageFormatter) {
        if (messageFormatter == null) {
            throw new InvalidArgumentException("messageFormatter", messageFormatter);
        }
        EmpireException.messageFormatter = messageFormatter;
    }

    public static String formatErrorMessage(ErrorType errType, String pattern, String[] params) {
        return messageFormatter.format(errType, pattern, params);
    }

    protected EmpireException(ErrorType errType, String[] params, Throwable cause) {
        super(messageFormatter.format(errType, null, params), cause);
        this.errorType = errType;
        this.errorParams = params;
        this.log();
    }

    protected EmpireException(ErrorType errType, String[] params) {
        this(errType, params, null);
    }

    protected void log() {
        if (log.isInfoEnabled()) {
            log.info("An Error occured. Message is: {}", (Object)this.getMessage());
        }
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String[] getErrorParams() {
        return this.errorParams;
    }

    public static class ExceptionMessageFormatter {
        protected String missingArgument = "?";

        public String format(ErrorType errType, String pattern, String[] params) {
            try {
                int paramCount;
                if (pattern == null) {
                    pattern = errType.getMessagePattern();
                }
                int patParamCount = errType.getNumParams();
                int extraParamIndex = -1;
                if (pattern.contains("{*}")) {
                    pattern = pattern.replace("{*}", "{" + String.valueOf(patParamCount) + "}");
                    extraParamIndex = patParamCount++;
                }
                int n = paramCount = params != null ? params.length : 0;
                if (paramCount < patParamCount) {
                    log.warn("Invalid Number of arguments supplied for error {}: Arguments expected={} / Arguments supplied={}.", new Object[]{errType.getKey(), patParamCount, paramCount});
                } else if (paramCount > patParamCount && extraParamIndex < 0) {
                    log.info("Additional arguments supplied for error {}: Arguments expected={} / Arguments supplied={}.", new Object[]{errType.getKey(), patParamCount, paramCount});
                }
                Object[] messageArgs = new String[patParamCount];
                for (int i = 0; i < messageArgs.length; ++i) {
                    if (i == extraParamIndex) {
                        StringBuilder b = new StringBuilder();
                        for (int j = extraParamIndex; j < paramCount; ++j) {
                            if (b.length() > 0) {
                                b.append(", ");
                            }
                            b.append(this.formatParam(errType, i, params[j]));
                        }
                        messageArgs[i] = b.toString();
                        continue;
                    }
                    messageArgs[i] = i < paramCount ? this.formatParam(errType, i, params[i]) : this.missingArgument;
                }
                String msg = MessageFormat.format(pattern, messageArgs);
                return msg;
            }
            catch (Exception e) {
                log.error("Unable to format error message: " + pattern, (Throwable)e);
                return pattern;
            }
        }

        protected Object formatParam(ErrorType errType, int index, String param) {
            return param;
        }
    }
}

