/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jso;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.jso.JsoBeanPropertyMeta;
import org.apache.juneau.jso.JsoClassMeta;
import org.apache.juneau.jso.JsoCommon;
import org.apache.juneau.jso.JsoMetaProvider;
import org.apache.juneau.jso.JsoSerializerBuilder;
import org.apache.juneau.jso.JsoSerializerSession;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializerSessionArgs;

@ConfigurableContext
public class JsoSerializer
extends OutputStreamSerializer
implements JsoMetaProvider,
JsoCommon {
    static final String PREFIX = "JsoSerializer";
    public static final JsoSerializer DEFAULT = new JsoSerializer(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, JsoClassMeta> jsoClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, JsoBeanPropertyMeta> jsoBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, JsoBeanPropertyMeta>();

    public JsoSerializer(PropertyStore ps) {
        super(ps, "application/x-java-serialized-object", null);
    }

    @Override
    public JsoSerializerBuilder builder() {
        return new JsoSerializerBuilder(this.getPropertyStore());
    }

    public static JsoSerializerBuilder create() {
        return new JsoSerializerBuilder();
    }

    @Override
    public JsoSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsoSerializerSession createSession(SerializerSessionArgs args) {
        return new JsoSerializerSession(this, args);
    }

    @Override
    public JsoClassMeta getJsoClassMeta(ClassMeta<?> cm) {
        JsoClassMeta m = this.jsoClassMetas.get(cm);
        if (m == null) {
            m = new JsoClassMeta(cm, this);
            this.jsoClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public JsoBeanPropertyMeta getJsoBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return JsoBeanPropertyMeta.DEFAULT;
        }
        JsoBeanPropertyMeta m = this.jsoBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new JsoBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.jsoBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }
}

