/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.transforms.TemporalSwap;
import org.apache.juneau.utils.MethodExecStats;

@Bean(bpi="startTime,upTime,methodStats")
public class RestContextStats {
    private final Instant startTime;
    private final List<MethodExecStats> methodStats;

    RestContextStats(Instant startTime, List<MethodExecStats> methodStats) {
        this.startTime = startTime;
        this.methodStats = methodStats;
    }

    @Swap(value=TemporalSwap.IsoInstant.class)
    public Instant getStartTime() {
        return this.startTime;
    }

    public String getUpTime() {
        long s = Duration.between(this.startTime, Instant.now()).getSeconds();
        return String.format("%dh:%02dm:%02ds", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    public Collection<MethodExecStats> getMethodStats() {
        return this.methodStats;
    }
}

