/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl.internal;

import org.apache.logging.log4j.kit.message.RecyclingMessageFactory;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableObjectMessage;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class ReusableMessageFactory
implements RecyclingMessageFactory {
    private final Recycler<ReusableParameterizedMessage> parameterizedMessageRecycler;
    private final Recycler<ReusableSimpleMessage> simpleMessageRecycler;
    private final Recycler<ReusableObjectMessage> objectMessageRecycler;

    public ReusableMessageFactory(RecyclerFactory recyclerFactory) {
        this.parameterizedMessageRecycler = recyclerFactory.create(ReusableParameterizedMessage::new, ReusableParameterizedMessage::clear);
        this.simpleMessageRecycler = recyclerFactory.create(ReusableSimpleMessage::new, ReusableSimpleMessage::clear);
        this.objectMessageRecycler = recyclerFactory.create(ReusableObjectMessage::new, ReusableObjectMessage::clear);
    }

    public void recycle(Message message) {
        if (message instanceof ReusableParameterizedMessage) {
            ReusableParameterizedMessage reusable = (ReusableParameterizedMessage)message;
            reusable.clear();
            this.parameterizedMessageRecycler.release((Object)reusable);
        } else if (message instanceof ReusableObjectMessage) {
            ReusableObjectMessage reusable = (ReusableObjectMessage)message;
            reusable.clear();
            this.objectMessageRecycler.release((Object)reusable);
        } else if (message instanceof ReusableSimpleMessage) {
            ReusableSimpleMessage reusable = (ReusableSimpleMessage)message;
            reusable.clear();
            this.simpleMessageRecycler.release((Object)reusable);
        }
    }

    public Message newMessage(CharSequence charSequence) {
        ReusableSimpleMessage result = (ReusableSimpleMessage)this.simpleMessageRecycler.acquire();
        result.set(charSequence);
        return result;
    }

    public Message newMessage(String message, Object ... params) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, params);
    }

    public Message newMessage(String message, Object p0) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0);
    }

    public Message newMessage(String message, Object p0, Object p1) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1, p2);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1, p2, p3);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1, p2, p3, p4);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1, p2, p3, p4, p5);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1, p2, p3, p4, p5, p6);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return ((ReusableParameterizedMessage)this.parameterizedMessageRecycler.acquire()).set(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public Message newMessage(String message) {
        ReusableSimpleMessage result = (ReusableSimpleMessage)this.simpleMessageRecycler.acquire();
        result.set(message);
        return result;
    }

    public Message newMessage(Object message) {
        ReusableObjectMessage result = (ReusableObjectMessage)this.objectMessageRecycler.acquire();
        result.set(message);
        return result;
    }
}

