/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.legacy;

import java.io.InputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.ComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.CountComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.CountEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.CountPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.MediaEntityProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.PrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.PrimitiveProcessor;
import org.apache.olingo.server.api.processor.PrimitiveValueProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.processor.ReferenceProcessor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.requests.ActionRequest;
import org.apache.olingo.server.core.requests.DataRequest;
import org.apache.olingo.server.core.requests.FunctionRequest;
import org.apache.olingo.server.core.requests.MediaRequest;
import org.apache.olingo.server.core.requests.MetadataRequest;
import org.apache.olingo.server.core.requests.ServiceDocumentRequest;
import org.apache.olingo.server.core.responses.CountResponse;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.apache.olingo.server.core.responses.EntitySetResponse;
import org.apache.olingo.server.core.responses.ErrorResponse;
import org.apache.olingo.server.core.responses.MetadataResponse;
import org.apache.olingo.server.core.responses.NoContentResponse;
import org.apache.olingo.server.core.responses.PrimitiveValueResponse;
import org.apache.olingo.server.core.responses.PropertyResponse;
import org.apache.olingo.server.core.responses.ServiceDocumentResponse;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;
import org.apache.olingo.server.core.responses.StreamResponse;

public class ProcessorServiceHandler
implements ServiceHandler {
    private final List<Processor> processors = new LinkedList<Processor>();
    private OData odata;
    private ServiceMetadata serviceMetadata;

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public void register(Processor processor) {
        this.processors.add(processor);
        processor.init(this.odata, this.serviceMetadata);
    }

    private <T extends Processor> T selectProcessor(Class<T> cls) throws ODataHandlerException {
        for (Processor processor : this.processors) {
            if (!cls.isAssignableFrom(processor.getClass())) continue;
            processor.init(this.odata, this.serviceMetadata);
            return (T)((Processor)cls.cast(processor));
        }
        throw new ODataHandlerException("Processor: " + cls.getSimpleName() + " not registered.", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED, new String[]{cls.getSimpleName()});
    }

    @Override
    public void readMetadata(MetadataRequest request, MetadataResponse response) throws ODataLibraryException, ODataApplicationException {
        this.selectProcessor(MetadataProcessor.class).readMetadata(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
    }

    @Override
    public void readServiceDocument(ServiceDocumentRequest request, ServiceDocumentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.selectProcessor(ServiceDocumentProcessor.class).readServiceDocument(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
    }

    @Override
    public <T extends ServiceResponse> void read(final DataRequest request, T response) throws ODataLibraryException, ODataApplicationException {
        response.accepts(new ServiceResponseVisior(){

            @Override
            public void visit(CountResponse response) throws ODataLibraryException, ODataApplicationException {
                if (request.getUriResourceProperty() != null) {
                    EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
                    if (edmProperty.isPrimitive()) {
                        ((CountPrimitiveCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(CountPrimitiveCollectionProcessor.class)).countPrimitiveCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo());
                    } else {
                        ((CountComplexCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(CountComplexCollectionProcessor.class)).countComplexCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo());
                    }
                } else {
                    ((CountEntityCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(CountEntityCollectionProcessor.class)).countEntityCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo());
                }
            }

            @Override
            public void visit(EntityResponse response) throws ODataLibraryException, ODataApplicationException {
                ((EntityProcessor)ProcessorServiceHandler.this.selectProcessor(EntityProcessor.class)).readEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
            }

            @Override
            public void visit(PrimitiveValueResponse response) throws ODataLibraryException, ODataApplicationException {
                ((PrimitiveValueProcessor)ProcessorServiceHandler.this.selectProcessor(PrimitiveValueProcessor.class)).readPrimitiveValue(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
            }

            @Override
            public void visit(PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
                EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
                if (edmProperty.isPrimitive()) {
                    if (edmProperty.isCollection()) {
                        ((PrimitiveCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(PrimitiveCollectionProcessor.class)).readPrimitiveCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                    } else {
                        ((PrimitiveProcessor)ProcessorServiceHandler.this.selectProcessor(PrimitiveProcessor.class)).readPrimitive(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                    }
                } else if (edmProperty.isCollection()) {
                    ((ComplexCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(ComplexCollectionProcessor.class)).readComplexCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                } else {
                    ((ComplexProcessor)ProcessorServiceHandler.this.selectProcessor(ComplexProcessor.class)).readComplex(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                }
            }

            @Override
            public void visit(StreamResponse response) throws ODataLibraryException, ODataApplicationException {
                response.writeServerError(true);
            }

            @Override
            public void visit(EntitySetResponse response) throws ODataLibraryException, ODataApplicationException {
                ((EntityCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(EntityCollectionProcessor.class)).readEntityCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
            }
        });
    }

    @Override
    public void createEntity(DataRequest request, Entity entity, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        if (request.getEntitySet().getEntityType().hasStream()) {
            this.selectProcessor(MediaEntityProcessor.class).createMediaEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
        } else {
            this.selectProcessor(EntityProcessor.class).createEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
        }
    }

    @Override
    public void updateEntity(DataRequest request, Entity entity, boolean merge, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        if (request.getEntitySet().getEntityType().hasStream()) {
            this.selectProcessor(MediaEntityProcessor.class).updateMediaEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
        } else {
            this.selectProcessor(EntityProcessor.class).updateEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
        }
    }

    @Override
    public void deleteEntity(DataRequest request, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        this.selectProcessor(EntityProcessor.class).deleteEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo());
    }

    @Override
    public void updateProperty(DataRequest request, Property property, boolean rawValue, boolean merge, String entityETag, PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
        if (property.isPrimitive()) {
            if (property.isCollection()) {
                this.selectProcessor(PrimitiveCollectionProcessor.class).updatePrimitiveCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
            } else {
                this.selectProcessor(PrimitiveProcessor.class).updatePrimitive(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
            }
        } else if (property.isCollection()) {
            this.selectProcessor(ComplexCollectionProcessor.class).updateComplexCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
        } else {
            this.selectProcessor(ComplexProcessor.class).updateComplex(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
        }
    }

    @Override
    public void upsertStreamProperty(DataRequest request, String entityETag, InputStream streamContent, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        throw new ODataHandlerException("not implemented", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public <T extends ServiceResponse> void invoke(final FunctionRequest request, HttpMethod method, T response) throws ODataLibraryException, ODataApplicationException {
        if (method != HttpMethod.GET) {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed.", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, new String[]{method.toString()});
        }
        response.accepts(new ServiceResponseVisior(){

            @Override
            public void visit(EntityResponse response) throws ODataLibraryException, ODataApplicationException {
                ((EntityProcessor)ProcessorServiceHandler.this.selectProcessor(EntityProcessor.class)).readEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
            }

            @Override
            public void visit(PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
                if (request.isReturnTypePrimitive()) {
                    if (request.isCollection()) {
                        ((PrimitiveCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(PrimitiveCollectionProcessor.class)).readPrimitiveCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                    } else {
                        ((PrimitiveProcessor)ProcessorServiceHandler.this.selectProcessor(PrimitiveProcessor.class)).readPrimitive(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                    }
                } else if (request.isCollection()) {
                    ((ComplexCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(ComplexCollectionProcessor.class)).readComplexCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                } else {
                    ((ComplexProcessor)ProcessorServiceHandler.this.selectProcessor(ComplexProcessor.class)).readComplex(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                }
            }

            @Override
            public void visit(EntitySetResponse response) throws ODataLibraryException, ODataApplicationException {
                ((EntityCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(EntityCollectionProcessor.class)).readEntityCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
            }
        });
    }

    @Override
    public <T extends ServiceResponse> void invoke(final ActionRequest request, String eTag, T response) throws ODataLibraryException, ODataApplicationException {
        HttpMethod method = request.getODataRequest().getMethod();
        if (method != HttpMethod.POST) {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed.", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, new String[]{method.toString()});
        }
        response.accepts(new ServiceResponseVisior(){

            @Override
            public void visit(EntityResponse response) throws ODataLibraryException, ODataApplicationException {
                ((EntityProcessor)ProcessorServiceHandler.this.selectProcessor(EntityProcessor.class)).readEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
            }

            @Override
            public void visit(PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
                if (request.isReturnTypePrimitive()) {
                    if (request.isCollection()) {
                        ((PrimitiveCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(PrimitiveCollectionProcessor.class)).readPrimitiveCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                    } else {
                        ((PrimitiveProcessor)ProcessorServiceHandler.this.selectProcessor(PrimitiveProcessor.class)).readPrimitive(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                    }
                } else if (request.isCollection()) {
                    ((ComplexCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(ComplexCollectionProcessor.class)).readComplexCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                } else {
                    ((ComplexProcessor)ProcessorServiceHandler.this.selectProcessor(ComplexProcessor.class)).readComplex(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
                }
            }

            @Override
            public void visit(EntitySetResponse response) throws ODataLibraryException, ODataApplicationException {
                ((EntityCollectionProcessor)ProcessorServiceHandler.this.selectProcessor(EntityCollectionProcessor.class)).readEntityCollection(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
            }
        });
    }

    @Override
    public void readMediaStream(MediaRequest request, StreamResponse response) throws ODataLibraryException, ODataApplicationException {
        this.selectProcessor(MediaEntityProcessor.class).readMediaEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
    }

    @Override
    public void upsertMediaStream(MediaRequest request, String entityETag, InputStream mediaContent, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.selectProcessor(MediaEntityProcessor.class).updateMediaEntity(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getRequestContentType(), request.getResponseContentType());
    }

    @Override
    public void anyUnsupported(ODataRequest request, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        throw new ODataHandlerException("not implemented", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public void addReference(DataRequest request, String entityETag, URI referenceId, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.selectProcessor(ReferenceProcessor.class).createReference(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
    }

    @Override
    public void updateReference(DataRequest request, String entityETag, URI referenceId, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.selectProcessor(ReferenceProcessor.class).updateReference(request.getODataRequest(), response.getODataResponse(), request.getUriInfo(), request.getResponseContentType());
    }

    @Override
    public void deleteReference(DataRequest request, URI deleteId, String entityETag, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.selectProcessor(ReferenceProcessor.class).deleteReference(request.getODataRequest(), response.getODataResponse(), request.getUriInfo());
    }

    @Override
    public String startTransaction() {
        return null;
    }

    @Override
    public void commit(String txnId) {
    }

    @Override
    public void rollback(String txnId) {
    }

    @Override
    public void crossJoin(DataRequest dataRequest, List<String> entitySetNames, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        throw new ODataHandlerException("not implemented", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public void upsertEntity(DataRequest request, Entity entity, boolean merge, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        throw new ODataHandlerException("not implemented", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public void apply(DataRequest dataRequest, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        throw new ODataHandlerException("not implemented", (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public boolean supportsDataIsolation() {
        return false;
    }

    @Override
    public void processError(ODataServerError error, ErrorResponse response) {
        response.writeError(error);
    }
}

