/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TernaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class LikeEscapeOperatorNode
extends TernaryOperatorNode {
    boolean addedEquals;
    String escape;

    LikeEscapeOperatorNode(ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, ContextManager contextManager) {
        super(valueNode, valueNode2, valueNode3, 3, contextManager);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        boolean bl;
        boolean bl2;
        super.bindExpression(fromList, subqueryList, list);
        String string = null;
        if (!this.leftOperand.requiresTypeFromContext() && !this.leftOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException((String)"42884", (Object[])new Object[]{"LIKE", "FUNCTION"});
        }
        if (this.rightOperand != null && !this.rightOperand.requiresTypeFromContext() && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException((String)"42884", (Object[])new Object[]{"LIKE", "FUNCTION"});
        }
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            if (!this.leftOperand.requiresTypeFromContext()) {
                this.receiver.setCollationInfo(this.leftOperand.getTypeServices());
            } else if (this.rightOperand != null && !this.rightOperand.requiresTypeFromContext()) {
                this.receiver.setCollationInfo(this.rightOperand.getTypeServices());
            } else {
                this.receiver.setCollationUsingCompilationSchema();
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                this.leftOperand.setType(this.receiver.getTypeServices());
            } else {
                this.leftOperand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
            this.leftOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        if (this.rightOperand != null && this.rightOperand.requiresTypeFromContext()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                this.rightOperand.setType(this.receiver.getTypeServices());
            } else {
                this.rightOperand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
            this.rightOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        this.bindToBuiltIn();
        if (!this.receiver.getTypeId().isStringTypeId()) {
            throw StandardException.newException((String)"42884", (Object[])new Object[]{"LIKE", "FUNCTION"});
        }
        if (!this.leftOperand.getTypeId().isStringTypeId()) {
            this.leftOperand = this.castArgToString(this.leftOperand);
        }
        if (this.rightOperand != null) {
            this.rightOperand = this.castArgToString(this.rightOperand);
        }
        if (bl2 = this.leftOperand instanceof CharConstantNode) {
            string = ((CharConstantNode)this.leftOperand).getString();
        }
        if (bl = this.rightOperand instanceof CharConstantNode) {
            this.escape = ((CharConstantNode)this.rightOperand).getString();
            if (this.escape.length() != 1) {
                throw StandardException.newException((String)"22019", (Object[])new Object[]{this.escape});
            }
        } else if (this.rightOperand == null) {
            bl = true;
        }
        if (!this.receiver.getTypeServices().compareCollationInfo(this.leftOperand.getTypeServices())) {
            throw StandardException.newException((String)"42ZA2", (Object[])new Object[]{this.receiver.getTypeServices().getSQLstring(), this.receiver.getTypeServices().getCollationName(), this.leftOperand.getTypeServices().getSQLstring(), this.leftOperand.getTypeServices().getCollationName()});
        }
        if (this.receiver instanceof ColumnReference && bl2 && bl && Like.isOptimizable(string)) {
            String string2 = null;
            if (this.escape != null) {
                string2 = Like.stripEscapesNoPatternChars(string, this.escape.charAt(0));
            } else if (string.indexOf(95) == -1 && string.indexOf(37) == -1) {
                string2 = string;
            }
            if (string2 != null) {
                ValueNode valueNode = this.receiver.getClone();
                this.addedEquals = true;
                BinaryComparisonOperatorNode binaryComparisonOperatorNode = new BinaryRelationalOperatorNode(0, valueNode, new CharConstantNode(string2, this.getContextManager()), false, this.getContextManager());
                binaryComparisonOperatorNode.setForQueryRewrite(true);
                binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)binaryComparisonOperatorNode.bindExpression(fromList, subqueryList, list);
                AndNode andNode = new AndNode(this, binaryComparisonOperatorNode, this.getContextManager());
                this.finishBindExpr();
                andNode.postBindFixup();
                return andNode;
            }
        }
        this.finishBindExpr();
        return this;
    }

    private void finishBindExpr() throws StandardException {
        boolean bl;
        this.bindComparisonOperator();
        boolean bl2 = bl = this.receiver.getTypeServices().isNullable() || this.leftOperand.getTypeServices().isNullable();
        if (this.rightOperand != null) {
            bl |= this.rightOperand.getTypeServices().isNullable();
        }
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl));
    }

    public void bindComparisonOperator() throws StandardException {
        TypeId typeId = this.receiver.getTypeId();
        TypeId typeId2 = this.leftOperand.getTypeId();
        if (!typeId.isStringTypeId()) {
            throw StandardException.newException((String)"42X53", (Object[])new Object[]{typeId.getSQLTypeName()});
        }
        if (!typeId2.isStringTypeId()) {
            throw StandardException.newException((String)"42X53", (Object[])new Object[]{typeId2.getSQLTypeName()});
        }
        if (this.rightOperand != null && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException((String)"42X53", (Object[])new Object[]{this.rightOperand.getTypeId().getSQLTypeName()});
        }
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        BinaryRelationalOperatorNode binaryRelationalOperatorNode;
        ValueNode valueNode;
        Object object;
        boolean bl = false;
        String string = null;
        String string2 = null;
        super.preprocess(n, fromList, subqueryList, predicateList);
        if (this.receiver.getTypeId().getSQLTypeName().equals("CLOB")) {
            return this;
        }
        if (this.addedEquals) {
            return this;
        }
        if (!(this.leftOperand instanceof CharConstantNode) && !this.leftOperand.requiresTypeFromContext()) {
            return this;
        }
        if (!(this.receiver instanceof ColumnReference)) {
            return this;
        }
        if (this.receiver.getTypeServices().getCollationType() != 0) {
            return this;
        }
        if (this.leftOperand instanceof CharConstantNode) {
            object = ((CharConstantNode)this.leftOperand).getString();
            if (!Like.isOptimizable((String)object)) {
                return this;
            }
            int n2 = this.receiver.getTypeServices().getMaximumWidth();
            if (n2 > 32700) {
                return this;
            }
            string = Like.greaterEqualString((String)object, this.escape, n2);
            string2 = Like.lessThanString((String)object, this.escape, n2);
            bl = !Like.isLikeComparisonNeeded((String)object);
        }
        object = null;
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, this.getContextManager());
        if (string2 != null || this.leftOperand.requiresTypeFromContext()) {
            valueNode = this.leftOperand.requiresTypeFromContext() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "lessThanStringFromParameter", this.receiver.getTypeServices().getMaximumWidth()) : new CharConstantNode(string2, this.getContextManager());
            binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(4, this.receiver.getClone(), valueNode, false, this.getContextManager());
            binaryRelationalOperatorNode.setForQueryRewrite(true);
            binaryRelationalOperatorNode.bindComparisonOperator();
            binaryRelationalOperatorNode.setBetweenSelectivity();
            object = new AndNode(binaryRelationalOperatorNode, booleanConstantNode, this.getContextManager());
            ((AndNode)object).postBindFixup();
        }
        valueNode = this.leftOperand.requiresTypeFromContext() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "greaterEqualStringFromParameter", this.receiver.getTypeServices().getMaximumWidth()) : new CharConstantNode(string, this.getContextManager());
        binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(1, this.receiver.getClone(), valueNode, false, this.getContextManager());
        binaryRelationalOperatorNode.setForQueryRewrite(true);
        binaryRelationalOperatorNode.bindComparisonOperator();
        binaryRelationalOperatorNode.setBetweenSelectivity();
        object = object == null ? new AndNode(binaryRelationalOperatorNode, booleanConstantNode, this.getContextManager()) : new AndNode(binaryRelationalOperatorNode, (ValueNode)object, this.getContextManager());
        ((AndNode)object).postBindFixup();
        if (!bl) {
            object = new AndNode(this, (ValueNode)object, this.getContextManager());
            ((AndNode)object).postBindFixup();
        }
        this.setTransformed();
        return object;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.receiver.generateExpression(expressionClassBuilder, methodBuilder);
        this.receiverInterfaceType = this.receiver.getTypeCompiler().interfaceName();
        methodBuilder.upCast(this.receiverInterfaceType);
        this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.upCast(this.leftInterfaceType);
        if (this.rightOperand != null) {
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.rightInterfaceType);
        }
        methodBuilder.callMethod((short)185, null, this.methodName, this.resultInterfaceType, this.rightOperand == null ? 1 : 2);
    }

    private ValueNode setupOptimizeStringFromParameter(ValueNode valueNode, ValueNode valueNode2, String object, int n) throws StandardException {
        ValueNode[] valueNodeArray;
        if (valueNode2 != null) {
            object = (String)object + "WithEsc";
        }
        StaticMethodCallNode staticMethodCallNode = new StaticMethodCallNode((String)object, "org.apache.derby.iapi.types.Like", this.getContextManager());
        staticMethodCallNode.internalCall = true;
        NumericConstantNode numericConstantNode = new NumericConstantNode(TypeId.getBuiltInTypeId(4), n, this.getContextManager());
        if (valueNode2 == null) {
            ValueNode[] valueNodeArray2 = new ValueNode[2];
            valueNodeArray2[0] = valueNode;
            valueNodeArray = valueNodeArray2;
            valueNodeArray2[1] = numericConstantNode;
        } else {
            ValueNode[] valueNodeArray3 = new ValueNode[3];
            valueNodeArray3[0] = valueNode;
            valueNodeArray3[1] = valueNode2;
            valueNodeArray = valueNodeArray3;
            valueNodeArray3[2] = numericConstantNode;
        }
        ValueNode[] valueNodeArray4 = valueNodeArray;
        staticMethodCallNode.addParms(Arrays.asList(valueNodeArray4));
        ValueNode valueNode3 = new JavaToSQLValueNode(staticMethodCallNode, this.getContextManager());
        valueNode3 = ((ValueNode)valueNode3).bindExpression(null, null, null);
        CastNode castNode = new CastNode(valueNode3, valueNode.getTypeServices(), this.getContextManager());
        castNode.bindCastNodeOnly();
        return castNode;
    }
}

