/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.util;

public class PathUtil {
    public static String join(String first, String second) {
        boolean relativePathHasLeadingSlash;
        boolean repoUrlHasTrailingSlash = first.endsWith("/");
        boolean bl = relativePathHasLeadingSlash = !second.isEmpty() && second.charAt(0) == '/';
        if (repoUrlHasTrailingSlash ^ relativePathHasLeadingSlash) {
            return first + second;
        }
        if (!repoUrlHasTrailingSlash && !relativePathHasLeadingSlash) {
            return first + "/" + second;
        }
        if (repoUrlHasTrailingSlash && relativePathHasLeadingSlash) {
            return first + second.substring(1);
        }
        throw new AssertionError((Object)"unreachable");
    }

    public static String getName(String path) {
        if (path.length() == 1 && path.charAt(0) == '/') {
            return path;
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String getParent(String path) {
        if (path == null || path.length() == 0 || path.charAt(0) != '/' || path.indexOf(47) == -1) {
            throw new IllegalArgumentException("No a valid or absolut path: " + path);
        }
        if (path.equals("/")) {
            return null;
        }
        if (path.lastIndexOf(47) == 0) {
            return "/";
        }
        return path.substring(0, path.lastIndexOf(47));
    }

    public static boolean isAncestor(String ancestor, String child) {
        while ((child = PathUtil.getParent(child)) != null) {
            if (!child.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isParent(String parentPath, String childPath) {
        if (!PathUtil.isDescendent(parentPath, childPath)) {
            return false;
        }
        for (int i = parentPath.length() + 1; i < childPath.length(); ++i) {
            if (childPath.charAt(i) != '/') continue;
            return false;
        }
        return true;
    }

    public static boolean isDescendent(String parentPath, String childPath) {
        if (parentPath.equals("/")) {
            return childPath.length() > 1;
        }
        return parentPath.length() < childPath.length() && childPath.charAt(parentPath.length()) == '/' && childPath.startsWith(parentPath);
    }

    private PathUtil() {
    }
}

