/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.felix.http.jakartawrappers.ServletConfigWrapper;
import org.apache.felix.http.jakartawrappers.ServletExceptionUtil;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.servlets.JakartaOptingServlet;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxResponseWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaxToJakartaServletWrapper
implements jakarta.servlet.Servlet {
    private final Servlet servlet;

    @Nullable
    public static jakarta.servlet.Servlet toJakartaServlet(@Nullable Servlet servlet) {
        if (servlet != null) {
            if (servlet instanceof OptingServlet) {
                return new JavaxToJakartaOptingServletWrapper((OptingServlet)servlet);
            }
            return new JavaxToJakartaServletWrapper(servlet);
        }
        return null;
    }

    public JavaxToJakartaServletWrapper(Servlet servlet) {
        this.servlet = servlet;
    }

    public void init(jakarta.servlet.ServletConfig config) throws jakarta.servlet.ServletException {
        try {
            this.servlet.init((ServletConfig)new org.apache.felix.http.javaxwrappers.ServletConfigWrapper(config));
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException((ServletException)e);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws jakarta.servlet.ServletException, IOException {
        try {
            this.servlet.service(JakartaToJavaxRequestWrapper.toJavaxRequest(req), JakartaToJavaxResponseWrapper.toJavaxResponse(res));
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException((ServletException)e);
        }
    }

    public void destroy() {
        this.servlet.destroy();
    }

    public jakarta.servlet.ServletConfig getServletConfig() {
        if (this.servlet.getServletConfig() == null) {
            return null;
        }
        return new ServletConfigWrapper(this.servlet.getServletConfig());
    }

    public String getServletInfo() {
        return this.servlet.getServletInfo();
    }

    public static class JavaxToJakartaOptingServletWrapper
    extends JavaxToJakartaServletWrapper
    implements JakartaOptingServlet {
        private final OptingServlet servlet;

        public JavaxToJakartaOptingServletWrapper(OptingServlet servlet) {
            super(servlet);
            this.servlet = servlet;
        }

        @Override
        public boolean accepts(@NotNull SlingJakartaHttpServletRequest request) {
            return this.servlet.accepts(JakartaToJavaxRequestWrapper.toJavaxRequest(request));
        }
    }
}

