/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.util.HashSet;
import java.util.Set;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.Descriptor;
import org.apache.sling.cta.impl.AgentInfo;
import org.apache.sling.cta.impl.MBeanAwareTimeoutTransformer;

class JdkHttpRequestBuilderTimeoutTransformer
extends MBeanAwareTimeoutTransformer {
    static final Set<String> CLASSES_TO_TRANSFORM = new HashSet<String>();
    private final long readTimeoutMillis;

    public JdkHttpRequestBuilderTimeoutTransformer(long readTimeout, AgentInfo agentInfo) {
        super(agentInfo, CLASSES_TO_TRANSFORM);
        this.readTimeoutMillis = readTimeout;
    }

    @Override
    protected byte[] doTransformClass(CtClass cc) throws Exception {
        CtMethod buildMethod = cc.getDeclaredMethod("build");
        buildMethod.insertBefore("if ( this.duration == null ) { timeout(java.time.Duration.ofMillis(" + this.readTimeoutMillis + "L)); }");
        byte[] classfileBuffer = buildMethod.getDeclaringClass().toBytecode();
        buildMethod.getDeclaringClass().detach();
        return classfileBuffer;
    }

    static {
        CLASSES_TO_TRANSFORM.add(Descriptor.toJvmName("jdk.internal.net.http.HttpRequestBuilderImpl"));
    }
}

