/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers;

import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;

public class EventHelper {
    public static TopologyEvent newInitEvent(BaseTopologyView newView) {
        if (newView == null) {
            throw new IllegalStateException("newView must not be null");
        }
        if (!newView.isCurrent()) {
            throw new IllegalStateException("newView must be current");
        }
        return new TopologyEvent(TopologyEvent.Type.TOPOLOGY_INIT, null, (TopologyView)newView);
    }

    public static TopologyEvent newChangingEvent(BaseTopologyView oldView) {
        if (oldView == null) {
            throw new IllegalStateException("oldView must not be null");
        }
        if (oldView.isCurrent()) {
            throw new IllegalStateException("oldView must not be current");
        }
        return new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGING, (TopologyView)oldView, null);
    }

    public static TopologyEvent newChangedEvent(BaseTopologyView oldView, BaseTopologyView newView) {
        if (oldView == null) {
            throw new IllegalStateException("oldView must not be null");
        }
        if (oldView.isCurrent()) {
            throw new IllegalStateException("oldView must not be current");
        }
        if (newView == null) {
            throw new IllegalStateException("newView must not be null");
        }
        if (!newView.isCurrent()) {
            throw new IllegalStateException("newView must be current");
        }
        return new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, (TopologyView)oldView, (TopologyView)newView);
    }

    public static TopologyEvent newPropertiesChangedEvent(BaseTopologyView oldView, BaseTopologyView newView) {
        if (oldView == null) {
            throw new IllegalStateException("oldView must not be null");
        }
        if (oldView.isCurrent()) {
            throw new IllegalStateException("oldView must not be current");
        }
        if (newView == null) {
            throw new IllegalStateException("newView must not be null");
        }
        if (!newView.isCurrent()) {
            throw new IllegalStateException("newView must be current");
        }
        return new TopologyEvent(TopologyEvent.Type.PROPERTIES_CHANGED, (TopologyView)oldView, (TopologyView)newView);
    }

    public static String toShortString(TopologyEvent event) {
        String newViewtoString;
        String oldViewToString;
        TopologyView oldView = event.getOldView();
        TopologyView newView = event.getNewView();
        if (oldView instanceof BaseTopologyView) {
            BaseTopologyView baseOldView = (BaseTopologyView)oldView;
            oldViewToString = baseOldView.toShortString();
        } else {
            oldViewToString = String.valueOf(oldView);
        }
        if (newView instanceof BaseTopologyView) {
            BaseTopologyView baseNewView = (BaseTopologyView)newView;
            newViewtoString = baseNewView.toShortString();
        } else {
            newViewtoString = String.valueOf(newView);
        }
        return "TopologyEvent [type=" + String.valueOf(event.getType()) + ", oldView=" + oldViewToString + ", newView=" + newViewtoString + "]";
    }
}

