/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.JcrEventDistributionTrigger;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionTrigger.class}, property={"webconsole.configurationFactory.nameHint=Trigger name: {name} on path {path}"})
@Designate(ocd=Config.class, factory=true)
public class JcrEventDistributionTriggerFactory
implements DistributionTrigger {
    private JcrEventDistributionTrigger trigger;
    @Reference
    private SlingRepository repository;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resolverFactory;

    @Activate
    public void activate(Config conf) {
        String path = conf.path();
        String serviceName = SettingsUtils.removeEmptyEntry(conf.serviceName());
        String[] ignoredPathsPatterns = conf.ignoredPathsPatterns();
        ignoredPathsPatterns = SettingsUtils.removeEmptyEntries(ignoredPathsPatterns);
        boolean deep = conf.deep();
        this.trigger = new JcrEventDistributionTrigger(this.repository, this.scheduler, this.resolverFactory, path, deep, serviceName, ignoredPathsPatterns);
        this.trigger.enable();
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Trigger - Jcr Event Triggers Factory", description="Triggers a distribution request ('ADD', 'DELETE') for the given path (path) whenever the JCR node at the given path is modified (added, resp. removed).")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the trigger.")
        public String name();

        @AttributeDefinition(name="Name", description="The path for which changes are distributed.")
        public String path();

        @AttributeDefinition(cardinality=100, name="Ignored Paths Patterns", description="The paths matching one of these patterns will be ignored.")
        public String[] ignoredPathsPatterns();

        @AttributeDefinition(name="Service Name", description="The service used to listen for jcr events")
        public String serviceName();

        @AttributeDefinition(name="Use deep distribution", description="Distribute entire subtree of the event node path. Default is 'false'.")
        public boolean deep() default false;
    }
}

