/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ops4j.peaberry.AttributeFilter;
import org.ops4j.peaberry.Export;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceWatcher;
import org.ops4j.peaberry.cache.AbstractServiceImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceListener<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractServiceListener.class.getName());
    private final List<AbstractServiceImport<T>> imports = new ArrayList<AbstractServiceImport<T>>(4);
    private final List<ServiceWatcher<T>> watchers = new ArrayList<ServiceWatcher<T>>(2);

    protected AbstractServiceListener() {
    }

    synchronized void addWatcher(ServiceWatcher watcher) {
        if (!this.watchers.contains(watcher) && this.watchers.add(watcher)) {
            for (AbstractServiceImport<T> i : this.imports) {
                AbstractServiceListener.notifyWatcher(watcher, i);
            }
        }
    }

    synchronized void flush(int targetGeneration) {
        for (AbstractServiceImport<T> i : this.imports) {
            i.flush(targetGeneration);
        }
    }

    protected final void insertService(AbstractServiceImport<T> i) {
        int insertIndex = Collections.binarySearch(this.imports, i);
        if (insertIndex < 0) {
            this.imports.add(~insertIndex, i);
            for (ServiceWatcher<T> w : this.watchers) {
                AbstractServiceListener.notifyWatcher(w, i);
            }
        }
    }

    protected final void updateService(AbstractServiceImport<T> i) {
        int index = this.imports.indexOf(i);
        if (0 <= index) {
            AbstractServiceImport<T> orig = this.imports.get(index);
            if (orig.hasRankingChanged()) {
                this.imports.remove(index);
                this.imports.add(~Collections.binarySearch(this.imports, orig), orig);
            }
            orig.notifyWatchers(0);
        } else {
            this.insertService(i);
        }
    }

    protected final void removeService(Import<T> i) {
        int index = this.imports.indexOf(i);
        if (0 <= index) {
            this.imports.remove(index).invalidate();
        }
    }

    private static void notifyWatcher(ServiceWatcher watcher, AbstractServiceImport i) {
        try {
            Export export = watcher.add(i);
            if (null != export) {
                i.addWatcher(export);
            }
        }
        catch (RuntimeException re) {
            LOGGER.log(Level.WARNING, "Exception in service watcher", re);
        }
    }

    synchronized Import<T> findNextImport(Import<T> prevImport, AttributeFilter filter) {
        if (this.imports.isEmpty()) {
            return null;
        }
        if (null == prevImport && null == filter) {
            return this.imports.get(0);
        }
        return this.findNextImport(filter, null == prevImport ? -1 : Collections.binarySearch(this.imports, prevImport));
    }

    private Import<T> findNextImport(AttributeFilter filter, int prevIndex) {
        int i;
        int n = i = prevIndex < 0 ? ~prevIndex : prevIndex + 1;
        while (i < this.imports.size()) {
            Import nextImport = this.imports.get(i);
            if (null == filter || filter.matches(nextImport.attributes())) {
                return nextImport;
            }
            ++i;
        }
        return null;
    }

    protected abstract void start();
}

