/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.NodeImpl;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.lock.LockStateManager;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrLockManager
implements LockManager {
    private static final Logger log = LoggerFactory.getLogger(JcrLockManager.class);
    private final LockStateManager lockStateMgr;
    private final ItemManager itemManager;
    private final PathResolver resolver;

    protected JcrLockManager(SessionImpl session) {
        this.lockStateMgr = session.getLockStateManager();
        this.itemManager = session.getItemManager();
        this.resolver = session.getPathResolver();
    }

    public Lock getLock(String absPath) throws LockException, RepositoryException {
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        return n.getLock();
    }

    public boolean isLocked(String absPath) throws RepositoryException {
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        return n.isLocked();
    }

    public boolean holdsLock(String absPath) throws RepositoryException {
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        return n.holdsLock();
    }

    public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws RepositoryException {
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        return ((NodeImpl)n).lock(isDeep, isSessionScoped, timeoutHint, ownerInfo);
    }

    public void unlock(String absPath) throws LockException, RepositoryException {
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        n.unlock();
    }

    public String[] getLockTokens() throws RepositoryException {
        return this.lockStateMgr.getLockTokens();
    }

    public void addLockToken(String lt) throws LockException, RepositoryException {
        this.lockStateMgr.addLockToken(lt);
    }

    public void removeLockToken(String lt) throws LockException, RepositoryException {
        this.lockStateMgr.removeLockToken(lt);
    }
}

