/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.impl.util;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.jackrabbit.vault.validation.impl.util.EnhancedBufferedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettableInputStream
extends InputStream {
    private final Path tmpFile;
    private final OutputStream tmpOutputStream;
    private InputStream currentInput;
    private boolean isAtStart;
    private static final Logger log = LoggerFactory.getLogger(ResettableInputStream.class);

    public ResettableInputStream(InputStream in) throws IOException {
        InputStream unwrappedInput = EnhancedBufferedInputStream.tryUnwrap(in);
        if (!(unwrappedInput instanceof FileInputStream)) {
            this.tmpFile = Files.createTempFile("vlt_tmp", null, new FileAttribute[0]);
            this.tmpOutputStream = new BufferedOutputStream(Files.newOutputStream(this.tmpFile, new OpenOption[0]));
            log.debug("Caching input stream in temp file '{}' for later evaluation by another validator", (Object)this.tmpFile);
            this.currentInput = new TeeInputStream(in, this.tmpOutputStream);
        } else {
            this.tmpFile = null;
            this.tmpOutputStream = null;
            this.currentInput = in;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        InputStream unwrappedInput = EnhancedBufferedInputStream.tryUnwrap(this.currentInput);
        if (unwrappedInput instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)FileInputStream.class.cast(unwrappedInput);
            fis.getChannel().position(0L);
            this.currentInput = new EnhancedBufferedInputStream(unwrappedInput);
        } else {
            if (this.tmpOutputStream == null) {
                throw new IllegalStateException("No output stream which buffers to a temp file has been created");
            }
            IOUtils.skip((InputStream)this.currentInput, (long)Long.MAX_VALUE);
            this.tmpOutputStream.close();
            this.currentInput = new EnhancedBufferedInputStream(Files.newInputStream(this.tmpFile, new OpenOption[0]));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.tmpOutputStream != null) {
            this.tmpOutputStream.close();
        }
        if (this.tmpFile != null) {
            Files.delete(this.tmpFile);
        }
        super.close();
    }

    @Override
    public int read() throws IOException {
        if (this.isAtStart) {
            this.isAtStart = false;
        }
        return this.currentInput.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.currentInput.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.currentInput.read(b, off, len);
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (!this.isAtStart) {
            throw new IllegalStateException("Currently only marking at the beginning of the input stream is supported");
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

