/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.loop;

import org.apache.sling.scripting.sightly.js.impl.loop.EventLoop;
import org.apache.sling.scripting.sightly.js.impl.loop.Task;
import org.mozilla.javascript.Context;

public class EventLoopInterop {
    public static final String EVENT_LOOP_KEY = "EventLoop";

    public static EventLoop obtainEventLoop(Context context) {
        EventLoop eventLoop = EventLoopInterop.getEventLoop(context);
        if (eventLoop == null) {
            eventLoop = new EventLoop();
            context.putThreadLocal((Object)EVENT_LOOP_KEY, (Object)eventLoop);
        }
        return eventLoop;
    }

    public static void cleanupEventLoop(Context context) {
        context.removeThreadLocal((Object)EVENT_LOOP_KEY);
    }

    public static Task schedule(Context context, Runnable runnable) {
        Task task = new Task(runnable);
        EventLoopInterop.obtainEventLoop(context).schedule(task);
        return task;
    }

    private static EventLoop getEventLoop(Context context) {
        return (EventLoop)context.getThreadLocal((Object)EVENT_LOOP_KEY);
    }
}

