/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.jdkcompat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;

public class Java23Subject {
    static Method current;
    static Method callAs;

    public static Subject getSubject() {
        Subject result;
        if (current != null) {
            try {
                result = (Subject)current.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SecurityException(e);
            }
        } else {
            result = Subject.getSubject(AccessController.getContext());
        }
        return result;
    }

    public static <T> T doAs(Subject subject, PrivilegedAction<T> action) {
        Object result;
        if (callAs != null) {
            try {
                result = callAs.invoke(null, subject, () -> action.run());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SecurityException(e);
            }
        } else {
            result = Subject.doAs(subject, action);
        }
        return result;
    }

    public static <T> T doAsPrivileged(Subject subject, PrivilegedAction<T> action, AccessControlContext acc) {
        Object result;
        if (callAs != null) {
            try {
                result = callAs.invoke(null, subject, () -> action.run());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SecurityException(e);
            }
        } else {
            result = Subject.doAsPrivileged(subject, action, acc);
        }
        return result;
    }

    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Object result;
        if (callAs != null) {
            try {
                result = callAs.invoke(null, subject, () -> action.run());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SecurityException(e);
            }
        } else {
            result = Subject.doAs(subject, action);
        }
        return result;
    }

    public static <T> T doAsPrivileged(Subject subject, PrivilegedExceptionAction<T> action, AccessControlContext acc) throws PrivilegedActionException {
        Object result;
        if (callAs != null) {
            try {
                result = callAs.invoke(null, subject, () -> action.run());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SecurityException(e);
            }
        } else {
            result = Subject.doAsPrivileged(subject, action, acc);
        }
        return result;
    }

    static {
        try {
            current = Subject.class.getMethod("current", new Class[0]);
            callAs = Subject.class.getMethod("callAs", Subject.class, Callable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

