/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Supplier;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.internal.function.Suppliers;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.security.AccessManager;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.WorkspaceImpl;
import org.apache.jackrabbit.oak.jcr.version.VersionManagerImpl;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.nodetype.DefinitionProvider;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.oak.spi.xml.Importer;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.apache.jackrabbit.oak.spi.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImporterImpl
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(ImporterImpl.class);
    private final Tree importTargetTree;
    private final Tree ntTypesRoot;
    private final int uuidBehavior;
    private final String userID;
    private final AccessManager accessManager;
    private final EffectiveNodeTypeProvider effectiveNodeTypeProvider;
    private final DefinitionProvider definitionProvider;
    private final IdResolver idLookup;
    private final Stack<Tree> parents;
    private final ReferenceChangeTracker refTracker;
    private final List<ProtectedItemImporter> pItemImporters = new ArrayList<ProtectedItemImporter>();
    private ProtectedNodeImporter pnImporter;

    public ImporterImpl(String absPath, SessionContext sessionContext, Root root, int uuidBehavior, boolean isWorkspaceImport) throws RepositoryException {
        NodeDelegate nd;
        String oakPath = sessionContext.getOakPath(absPath);
        if (oakPath == null) {
            throw new RepositoryException("Invalid name or path: " + absPath);
        }
        if (!PathUtils.isAbsolute(oakPath)) {
            throw new RepositoryException("Not an absolute path: " + absPath);
        }
        SessionDelegate sd = sessionContext.getSessionDelegate();
        if (isWorkspaceImport && sd.hasPendingChanges()) {
            throw new RepositoryException("Pending changes on session. Cannot run workspace import.");
        }
        this.uuidBehavior = uuidBehavior;
        this.userID = sd.getAuthInfo().getUserID();
        this.importTargetTree = root.getTree(oakPath);
        if (!this.importTargetTree.exists()) {
            throw new PathNotFoundException(absPath);
        }
        WorkspaceImpl wsp = sessionContext.getWorkspace();
        VersionManagerImpl vMgr = wsp.internalGetVersionManager();
        if (!vMgr.isCheckedOut(nd = new NodeDelegate(sd, this.importTargetTree))) {
            throw new VersionException("Target node is checked in: " + absPath);
        }
        boolean hasLocking = sessionContext.getRepository().getDescriptorValue("option.locking.supported").getBoolean();
        if (this.importTargetTree.getStatus() != Tree.Status.NEW && hasLocking && nd.isLocked()) {
            throw new LockException("Target node is locked: " + absPath);
        }
        this.effectiveNodeTypeProvider = wsp.getNodeTypeManager();
        this.definitionProvider = wsp.getNodeTypeManager();
        this.ntTypesRoot = root.getTree("/jcr:system/jcr:nodeTypes");
        this.accessManager = sessionContext.getAccessManager();
        this.idLookup = new IdResolver(root, sd.getContentSession());
        this.refTracker = new ReferenceChangeTracker();
        this.parents = new Stack();
        this.parents.push(this.importTargetTree);
        this.pItemImporters.clear();
        for (ProtectedItemImporter importer : sessionContext.getProtectedItemImporters()) {
            if (!importer.init(sessionContext.getSession(), root, sessionContext, isWorkspaceImport, uuidBehavior, this.refTracker, sessionContext.getSecurityProvider())) continue;
            this.pItemImporters.add(importer);
        }
    }

    private Tree createTree(@NotNull Tree parent, @NotNull NodeInfo nInfo, @Nullable String uuid) throws RepositoryException {
        String ntName = nInfo.getPrimaryTypeName();
        Tree child = TreeUtil.addChild(parent, nInfo.getName(), ntName, this.ntTypesRoot, this.userID);
        if (ntName != null) {
            this.accessManager.checkPermissions(child, child.getProperty("jcr:primaryType"), 512L);
        }
        if (uuid != null) {
            child.setProperty("jcr:uuid", uuid);
        }
        for (String mixin : nInfo.getMixinTypeNames()) {
            TreeUtil.addMixin(child, mixin, this.ntTypesRoot, this.userID);
        }
        return child;
    }

    private void createProperty(Tree tree, PropInfo pInfo, PropertyDefinition def) throws RepositoryException {
        tree.setProperty(pInfo.asPropertyState(def));
        int type = pInfo.getType();
        if (type == 9 || type == 10) {
            this.refTracker.processedReference(new Reference(tree, pInfo.getName()));
        }
    }

    private Tree resolveUUIDConflict(Tree parent, Tree conflicting, String conflictingId, NodeInfo nodeInfo) throws RepositoryException {
        Tree tree;
        if (this.uuidBehavior == 0) {
            tree = this.createTree(parent, nodeInfo, UUID.randomUUID().toString());
            if (this.isNodeType(tree, "mix:referenceable")) {
                this.refTracker.put(nodeInfo.getUUID(), TreeUtil.getString(tree, "jcr:uuid"));
            }
        } else {
            if (this.uuidBehavior == 3) {
                String msg = "a node with uuid " + nodeInfo.getUUID() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            if (this.uuidBehavior == 1) {
                if (conflicting == null) {
                    String msg = "node with uuid " + conflictingId + " cannot be removed";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                if (this.importTargetTree.getPath().startsWith(conflicting.getPath())) {
                    String msg = "cannot remove ancestor node";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                conflicting.remove();
                tree = this.createTree(parent, nodeInfo, nodeInfo.getUUID());
            } else if (this.uuidBehavior == 2) {
                if (conflicting == null) {
                    String msg = "node with uuid " + conflictingId + " cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                if (conflicting.isRoot()) {
                    String msg = "root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                parent = conflicting.getParent();
                conflicting.remove();
                tree = this.createTree(parent, nodeInfo, nodeInfo.getUUID());
            } else {
                String msg = "unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return tree;
    }

    private void importProperties(@NotNull Tree tree, @NotNull List<PropInfo> propInfos, boolean ignoreRegular) throws RepositoryException {
        block0: for (PropInfo pi : propInfos) {
            EffectiveNodeType ent = this.effectiveNodeTypeProvider.getEffectiveNodeType(tree);
            PropertyDefinition def = ent.getPropertyDefinition(pi.getName(), pi.getType(), pi.isUnknownMultiple());
            if (def == null) {
                throw new ConstraintViolationException("No matching property definition found for " + pi.getName());
            }
            if (def.isProtected()) {
                log.debug("Protected property {}", (Object)pi.getName());
                for (ProtectedPropertyImporter ppi : this.getPropertyImporters()) {
                    if (!ppi.handlePropInfo(tree, pi, def)) continue;
                    log.debug("Protected property -> delegated to ProtectedPropertyImporter");
                    continue block0;
                }
                continue;
            }
            if (ignoreRegular) continue;
            this.createProperty(tree, pi, def);
        }
        for (ProtectedPropertyImporter ppi : this.getPropertyImporters()) {
            ppi.propertiesCompleted(tree);
        }
    }

    private Iterable<ProtectedPropertyImporter> getPropertyImporters() {
        return IterableUtils.filter(IterableUtils.transform(this.pItemImporters, importer -> {
            if (importer instanceof ProtectedPropertyImporter) {
                return (ProtectedPropertyImporter)importer;
            }
            return null;
        }), x -> x != null);
    }

    private Iterable<ProtectedNodeImporter> getNodeImporters() {
        return IterableUtils.filter(IterableUtils.transform(this.pItemImporters, importer -> {
            if (importer instanceof ProtectedNodeImporter) {
                return (ProtectedNodeImporter)importer;
            }
            return null;
        }), x -> x != null);
    }

    @Override
    public void start() throws RepositoryException {
    }

    @Override
    public void startNode(@NotNull NodeInfo nodeInfo, @NotNull List<PropInfo> propInfos) throws RepositoryException {
        Tree existing;
        NodeDefinition def;
        Tree parent = this.parents.peek();
        Tree tree = null;
        String id = nodeInfo.getUUID();
        String nodeName = nodeInfo.getName();
        String ntName = nodeInfo.getPrimaryTypeName();
        if (parent == null) {
            log.debug("Skipping node: {}", (Object)nodeName);
            this.parents.push(null);
            if (this.pnImporter != null) {
                this.pnImporter.startChildInfo(nodeInfo, propInfos);
            }
            return;
        }
        NodeDefinition parentDef = this.getDefinition(parent);
        if (parentDef.isProtected()) {
            this.parents.push(null);
            log.debug("Skipping protected node: {}", (Object)nodeName);
            if (this.pnImporter != null) {
                this.pnImporter.startChildInfo(nodeInfo, propInfos);
            } else {
                for (ProtectedNodeImporter pni : this.getNodeImporters()) {
                    if (!pni.start(parent)) continue;
                    log.debug("Protected node -> delegated to ProtectedNodeImporter");
                    this.pnImporter = pni;
                    this.pnImporter.startChildInfo(nodeInfo, propInfos);
                    break;
                }
            }
            return;
        }
        if (parent.hasChild(nodeName) && !(def = this.getDefinition(existing = parent.getChild(nodeName))).allowsSameNameSiblings()) {
            if (def.isProtected() && this.isNodeType(existing, ntName)) {
                log.debug("Skipping protected node: {}", (Object)existing);
                this.parents.push(existing);
                this.importProperties(existing, propInfos, true);
                return;
            }
            if (def.isAutoCreated() && this.isNodeType(existing, ntName)) {
                tree = existing;
            } else {
                String existingIdentifier = IdentifierManager.getIdentifier(existing);
                if (!existingIdentifier.equals(id) || this.uuidBehavior != 1 && this.uuidBehavior != 2) {
                    throw new ItemExistsException("Node with name " + nodeName + " already exists at this path.");
                }
            }
        }
        if (tree == null) {
            if (id == null) {
                tree = this.createTree(parent, nodeInfo, null);
            } else if (this.uuidBehavior == 0) {
                tree = this.createTree(parent, nodeInfo, UUID.randomUUID().toString());
                if (this.isNodeType(tree, "mix:referenceable")) {
                    this.refTracker.put(nodeInfo.getUUID(), TreeUtil.getString(tree, "jcr:uuid"));
                }
            } else {
                Tree conflicting = this.idLookup.getConflictingTree(id);
                if (conflicting != null && conflicting.exists()) {
                    tree = this.resolveUUIDConflict(parent, conflicting, id, nodeInfo);
                    if (tree == null) {
                        this.parents.push(null);
                        log.debug("Skipping existing node {}", (Object)nodeInfo.getName());
                        return;
                    }
                } else {
                    tree = this.createTree(parent, nodeInfo, id);
                }
            }
        }
        this.importProperties(tree, propInfos, false);
        if (tree.exists()) {
            this.parents.push(tree);
        }
    }

    @Override
    public void endNode(@NotNull NodeInfo nodeInfo) throws RepositoryException {
        Tree parent = this.parents.pop();
        if (parent == null) {
            if (this.pnImporter != null) {
                this.pnImporter.endChildInfo();
            }
        } else if (this.getDefinition(parent).isProtected() && this.pnImporter != null) {
            this.pnImporter.end(parent);
            this.pnImporter = null;
        }
        this.idLookup.rememberImportedUUIDs(parent);
    }

    @Override
    public void end() throws RepositoryException {
        for (ProtectedItemImporter ppi : this.pItemImporters) {
            ppi.processReferences();
        }
        Iterator<Object> iter = this.refTracker.getProcessedReferences();
        while (iter.hasNext()) {
            Object ref = iter.next();
            if (!(ref instanceof Reference)) continue;
            Reference reference = (Reference)ref;
            if (reference.isMultiple()) {
                Iterable<String> values = reference.property.getValue(Type.STRINGS);
                ArrayList<String> newValues = new ArrayList<String>();
                for (String original : values) {
                    String adjusted = this.refTracker.get(original);
                    if (adjusted != null) {
                        newValues.add(adjusted);
                        continue;
                    }
                    newValues.add(original);
                }
                reference.setProperty(newValues);
                continue;
            }
            String original = reference.property.getValue(Type.STRING);
            String adjusted = this.refTracker.get(original);
            if (adjusted == null) continue;
            reference.setProperty(adjusted);
        }
        this.refTracker.clear();
    }

    private boolean isNodeType(Tree tree, String ntName) throws RepositoryException {
        return this.effectiveNodeTypeProvider.isNodeType(tree, ntName);
    }

    private NodeDefinition getDefinition(Tree tree) throws RepositoryException {
        if (tree.isRoot()) {
            return this.definitionProvider.getRootDefinition();
        }
        return this.definitionProvider.getDefinition(tree.getParent(), tree);
    }

    private static final class IdResolver {
        private final IdentifierManager currentStateIdManager;
        private final Supplier<IdentifierManager> baseStateIdManager;
        private final Set<String> importedUUIDs;

        private IdResolver(@NotNull Root root, @NotNull ContentSession contentSession) {
            this.currentStateIdManager = new IdentifierManager(root);
            this.baseStateIdManager = Suppliers.memoize(() -> new IdentifierManager(contentSession.getLatestRoot()));
            this.importedUUIDs = !root.hasPendingChanges() ? new HashSet<String>() : null;
        }

        @Nullable
        private Tree getConflictingTree(@NotNull String id) {
            Tree conflicting = this.baseStateIdManager.get().getTree(id);
            if (conflicting == null && this.importedUUIDs != null) {
                if (this.importedUUIDs.contains(id)) {
                    conflicting = this.currentStateIdManager.getTree(id);
                }
            } else {
                conflicting = this.currentStateIdManager.getTree(id);
            }
            return conflicting;
        }

        private void rememberImportedUUIDs(@Nullable Tree tree) {
            if (tree == null || this.importedUUIDs == null) {
                return;
            }
            String uuid = TreeUtil.getString(tree, "jcr:uuid");
            if (uuid != null) {
                this.importedUUIDs.add(uuid);
            }
            for (Tree child : tree.getChildren()) {
                this.rememberImportedUUIDs(child);
            }
        }
    }

    private static final class Reference {
        private final Tree tree;
        private final PropertyState property;

        private Reference(Tree tree, String propertyName) {
            this.tree = tree;
            this.property = tree.getProperty(propertyName);
        }

        private boolean isMultiple() {
            return this.property.isArray();
        }

        private void setProperty(String newValue) {
            PropertyState prop = PropertyStates.createProperty(this.property.getName(), newValue, this.property.getType().tag());
            this.tree.setProperty(prop);
        }

        private void setProperty(Iterable<String> newValues) {
            PropertyState prop = PropertyStates.createProperty(this.property.getName(), newValues, this.property.getType());
            this.tree.setProperty(prop);
        }
    }
}

