/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.version.VersionSelector;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;

class DateVersionSelector
implements VersionSelector {
    private final long timestamp;

    public DateVersionSelector(String timestamp) {
        this.timestamp = ISO8601.parse(timestamp).getTimeInMillis();
    }

    @Override
    public NodeBuilder select(@NotNull NodeBuilder history) throws RepositoryException {
        long latestDate = Long.MIN_VALUE;
        NodeBuilder latestVersion = null;
        for (String name : history.getChildNodeNames()) {
            if (name.charAt(0) == ':') continue;
            NodeBuilder v = history.getChildNode(name);
            if (name.equals("jcr:rootVersion") || name.equals("jcr:versionLabels")) continue;
            long c = ISO8601.parse(v.getProperty("jcr:created").getValue(Type.DATE)).getTimeInMillis();
            if (c > latestDate && c <= this.timestamp) {
                latestDate = c;
                latestVersion = v;
                continue;
            }
            if (c != latestDate) continue;
            throw new RepositoryException("two versions share the same jcr:created timestamp in history:" + String.valueOf(history));
        }
        return latestVersion;
    }
}

