/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.query.SQL2Parser;
import org.apache.jackrabbit.oak.query.xpath.Selector;
import org.apache.jackrabbit.oak.query.xpath.XPathToSQL2Converter;
import org.apache.jackrabbit.util.ISO9075;

abstract class Expression {
    static final int PRECEDENCE_OR = 1;
    static final int PRECEDENCE_AND = 2;
    static final int PRECEDENCE_CONDITION = 3;
    static final int PRECEDENCE_OPERAND = 4;

    Expression() {
    }

    public static Expression and(Expression old, Expression add) {
        if (old == null) {
            return add;
        }
        if (add == null) {
            return old;
        }
        return new AndCondition(old, add);
    }

    Expression optimize() {
        return this;
    }

    boolean isCondition() {
        return false;
    }

    boolean containsFullTextCondition() {
        return false;
    }

    String getCommonLeftPart() {
        return null;
    }

    Expression getLeft() {
        return null;
    }

    List<Expression> getRight() {
        return null;
    }

    Expression pullOrRight() {
        return this;
    }

    int getPrecedence() {
        return 4;
    }

    String getColumnAliasName() {
        return this.toString();
    }

    boolean isName() {
        return false;
    }

    public String getMostSpecificNodeType(String selectorName) {
        return null;
    }

    static class Property
    extends Expression {
        final Selector selector;
        final String name;
        private String cacheString;
        private boolean cacheOnlySelector;
        final boolean thereWasNoAt;

        Property(Selector selector, String name, boolean thereWasNoAt) {
            this.selector = selector;
            this.name = name;
            this.thereWasNoAt = thereWasNoAt;
        }

        public String toString() {
            if (this.cacheString != null && this.cacheOnlySelector == this.selector.onlySelector) {
                return this.cacheString;
            }
            StringBuilder buff = new StringBuilder();
            if (!this.selector.onlySelector) {
                buff.append(this.selector.name).append('.');
            }
            if (this.name.equals("*")) {
                buff.append('*');
            } else {
                buff.append('[').append(this.name).append(']');
            }
            this.cacheString = buff.toString();
            this.cacheOnlySelector = this.selector.onlySelector;
            return this.cacheString;
        }

        @Override
        public String getColumnAliasName() {
            return this.name;
        }
    }

    static class SelectorExpr
    extends Expression {
        private final Selector selector;

        SelectorExpr(Selector selector) {
            this.selector = selector;
        }

        public String toString() {
            return this.selector.name;
        }
    }

    static class Cast
    extends Expression {
        final Expression expr;
        final String type;

        Cast(Expression expr, String type) {
            this.expr = expr;
            this.type = type;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("cast(");
            buff.append(this.expr.toString());
            buff.append(" as ").append(this.type).append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return false;
        }
    }

    static class Function
    extends Expression {
        final String name;
        final ArrayList<Expression> params = new ArrayList();

        Function(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder(this.name);
            buff.append('(');
            for (int i = 0; i < this.params.size(); ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.params.get(i).toString());
            }
            buff.append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return this.name.equals("contains") || this.name.equals("not");
        }

        @Override
        boolean isName() {
            if ("upper".equals(this.name) || "lower".equals(this.name)) {
                return this.params.get(0).isName();
            }
            return "name".equals(this.name);
        }
    }

    static class Suggest
    extends Expression {
        final Expression term;

        Suggest(Expression term) {
            this.term = term;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("suggest(");
            buff.append(this.term);
            buff.append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        boolean isName() {
            return false;
        }
    }

    static class Spellcheck
    extends Expression {
        final Expression term;

        Spellcheck(Expression term) {
            this.term = term;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("spellcheck(");
            buff.append(this.term);
            buff.append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        boolean isName() {
            return false;
        }
    }

    static class Similar
    extends Expression {
        final Expression property;
        final Expression path;

        Similar(Expression property, Expression path) {
            this.property = property;
            this.path = path;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("similar(");
            buff.append(this.property);
            buff.append(", ").append(this.path).append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        boolean isName() {
            return false;
        }
    }

    static class NativeFunction
    extends Expression {
        final String selector;
        final Expression language;
        final Expression expression;

        NativeFunction(String selector, Expression language, Expression expression) {
            this.selector = selector;
            this.language = language;
            this.expression = expression;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("native(");
            buff.append(this.selector);
            buff.append(", ").append(this.language).append(", ").append(this.expression).append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        boolean containsFullTextCondition() {
            return true;
        }

        @Override
        boolean isName() {
            return false;
        }
    }

    static class Contains
    extends Expression {
        final Expression left;
        final Expression right;

        Contains(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("contains(");
            Expression l = this.left;
            if (l instanceof Property) {
                Property p = (Property)l;
                if (p.thereWasNoAt) {
                    l = new Property(p.selector, p.name + "/*", true);
                }
            }
            buff.append(l);
            buff.append(", ").append(this.right).append(')');
            return buff.toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        boolean containsFullTextCondition() {
            return true;
        }

        @Override
        boolean isName() {
            return this.left.isName();
        }
    }

    static class AndCondition
    extends Condition {
        AndCondition(Expression left, Expression right) {
            super(left, "and", right, 2);
        }

        @Override
        Expression optimize() {
            Expression l = this.left.optimize();
            Expression r = this.right.optimize();
            if (l != this.left || r != this.right) {
                return new AndCondition(l, r);
            }
            return this;
        }

        @Override
        public String getMostSpecificNodeType(String selectorName) {
            String nt = this.left.getMostSpecificNodeType(selectorName);
            if (nt != null) {
                return nt;
            }
            return this.right.getMostSpecificNodeType(selectorName);
        }

        @Override
        AndCondition pullOrRight() {
            ArrayList<Expression> list = this.getAllAndConditions();
            OrCondition or = null;
            Expression result = null;
            for (Expression e : list) {
                if (e instanceof OrCondition && or == null) {
                    or = (OrCondition)e;
                    continue;
                }
                if (result == null) {
                    result = e;
                    continue;
                }
                result = new AndCondition(result, e);
            }
            if (or != null) {
                result = new AndCondition(result, or);
            }
            return result;
        }

        private ArrayList<Expression> getAllAndConditions() {
            ArrayList<Expression> list = new ArrayList<Expression>();
            if (this.left instanceof AndCondition) {
                list.addAll(((AndCondition)this.left).getAllAndConditions());
            } else {
                list.add(this.left);
            }
            if (this.right instanceof AndCondition) {
                list.addAll(((AndCondition)this.right).getAllAndConditions());
            } else {
                list.add(this.right);
            }
            return list;
        }

        @Override
        boolean containsFullTextCondition() {
            return this.left.containsFullTextCondition() || this.right.containsFullTextCondition();
        }
    }

    static class InCondition
    extends Expression {
        final Expression left;
        final List<Expression> list;

        InCondition(Expression left, List<Expression> list) {
            this.left = left;
            this.list = list;
        }

        @Override
        String getCommonLeftPart() {
            return this.left.toString();
        }

        @Override
        Expression getLeft() {
            return this.left;
        }

        @Override
        List<Expression> getRight() {
            return this.list;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append(this.left).append(" in(");
            for (int i = 0; i < this.list.size(); ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.list.get(i));
            }
            return buff.append(')').toString();
        }

        @Override
        boolean isCondition() {
            return true;
        }
    }

    static class OrCondition
    extends Condition {
        OrCondition(Expression left, Expression right) {
            super(left, "or", right, 1);
        }

        @Override
        public String getCommonLeftPart() {
            String l = this.left.getCommonLeftPart();
            String r = this.right.getCommonLeftPart();
            if (l != null && r != null && l.equals(r)) {
                return l;
            }
            return null;
        }

        @Override
        Expression optimize() {
            Expression l = this.left.optimize();
            Expression r = this.right.optimize();
            if (l != this.left || r != this.right) {
                return new OrCondition(l, r).optimize();
            }
            String commonLeft = this.getCommonLeftPart();
            if (commonLeft == null) {
                if (this.left instanceof OrCondition) {
                    OrCondition orLeft = (OrCondition)this.left;
                    Expression l1 = orLeft.left;
                    Expression l2 = orLeft.right;
                    OrCondition orRight = new OrCondition(l2, this.right);
                    Expression o2 = orRight.optimize();
                    if (o2 != orRight) {
                        return new OrCondition(l1, o2);
                    }
                }
                return this;
            }
            if (this.left instanceof InCondition) {
                InCondition in = (InCondition)this.left;
                in.list.addAll(this.right.getRight());
                in = new InCondition(in.getLeft(), in.list);
                return in;
            }
            Expression le = this.left.getLeft();
            if (XPathToSQL2Converter.NODETYPE_UNION && commonLeft.endsWith("[jcr:primaryType]")) {
                return this;
            }
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.addAll(this.left.getRight());
            list.addAll(this.right.getRight());
            InCondition in = new InCondition(le, list);
            return in;
        }

        @Override
        boolean containsFullTextCondition() {
            return this.left.containsFullTextCondition() || this.right.containsFullTextCondition();
        }
    }

    static class Condition
    extends Expression {
        final Expression left;
        final String operator;
        Expression right;
        final int precedence;

        Condition(Expression left, String operator, Expression right, int precedence) {
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.precedence = precedence;
        }

        @Override
        int getPrecedence() {
            return this.precedence;
        }

        @Override
        String getCommonLeftPart() {
            if (!"=".equals(this.operator)) {
                return null;
            }
            return this.left.toString();
        }

        @Override
        public String getMostSpecificNodeType(String selectorName) {
            if (!"=".equals(this.operator)) {
                return null;
            }
            if (!(this.left instanceof Property)) {
                return null;
            }
            Property p = (Property)this.left;
            if (!(this.right instanceof Literal)) {
                return null;
            }
            Literal l = (Literal)this.right;
            if (!"jcr:primaryType".equals(p.name)) {
                return null;
            }
            if (selectorName != null && !selectorName.equals(p.selector.name)) {
                return null;
            }
            return l.rawText;
        }

        @Override
        Expression getLeft() {
            return this.left;
        }

        @Override
        List<Expression> getRight() {
            return Collections.singletonList(this.right);
        }

        public String toString() {
            Object rightExpr;
            Object leftExpr;
            boolean leftExprIsName;
            if (this.left == null) {
                leftExprIsName = false;
                leftExpr = "";
            } else {
                leftExprIsName = this.left.isName();
                leftExpr = this.left.toString();
                if (this.left.getPrecedence() < this.precedence) {
                    leftExpr = "(" + (String)leftExpr + ")";
                }
            }
            boolean impossible = false;
            if (this.right == null) {
                rightExpr = "";
            } else {
                if (leftExprIsName && !"like".equals(this.operator)) {
                    if (!(this.right instanceof Literal)) {
                        throw new IllegalArgumentException("Can only compare a name against a string literal, not " + String.valueOf(this.right));
                    }
                    Literal l = (Literal)this.right;
                    String raw = l.rawText;
                    String decoded = ISO9075.decode(raw);
                    String encoded = ISO9075.encode(decoded);
                    rightExpr = SQL2Parser.escapeStringLiteral(decoded);
                    if (!encoded.equalsIgnoreCase(raw)) {
                        impossible = true;
                    }
                } else {
                    rightExpr = this.right.toString();
                }
                if (this.right.getPrecedence() < this.precedence) {
                    rightExpr = "(" + String.valueOf(this.right) + ")";
                }
            }
            if (impossible) {
                return "upper(" + (String)leftExpr + ") = 'never matches'";
            }
            return ((String)leftExpr + " " + this.operator + " " + (String)rightExpr).trim();
        }

        @Override
        boolean isCondition() {
            return true;
        }

        @Override
        Expression optimize() {
            return this;
        }
    }

    static class Literal
    extends Expression {
        final String value;
        final String rawText;

        Literal(String value, String rawText) {
            this.value = value;
            this.rawText = rawText;
        }

        public static Expression newBoolean(boolean value) {
            return new Literal(String.valueOf(value), String.valueOf(value));
        }

        static Literal newNumber(String s) {
            return new Literal(s, s);
        }

        static Literal newString(String s) {
            return new Literal(SQL2Parser.escapeStringLiteral(s), s);
        }

        static Literal newBindVariable(String s) {
            return new Literal("@" + s, s);
        }

        public String toString() {
            return this.value;
        }
    }
}

