/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query.fulltext;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VectorQueryConfig {
    public static final String TYPE = "inferenceModelConfig";
    @Nullable
    private final String inferenceModelConfig;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public VectorQueryConfig(@NotNull String queryConfig) {
        if (queryConfig.isBlank()) {
            this.inferenceModelConfig = null;
        } else if (queryConfig.equals("{}")) {
            this.inferenceModelConfig = "";
        } else {
            try {
                JsonNode jsonNode1 = objectMapper.readTree(queryConfig);
                this.inferenceModelConfig = jsonNode1.get(TYPE).asText();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error parsing inference query config: " + queryConfig + "error message: " + e.getMessage());
            }
        }
    }

    @Nullable
    public String getInferenceModelConfig() {
        return this.inferenceModelConfig;
    }
}

