/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.kep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.learner.kep.KEPRule;
import org.apache.uima.ruta.textruler.learner.kep.KEPRuleItem;
import org.apache.uima.ruta.textruler.learner.kep.KEPRuleItemCondition;

public class KEPLearner
extends TextRulerBasicLearner {
    public static final String MAX_EXPAND_RULES = "maxExpandRules";
    public static final String MAX_INFILLER_RULES = "maxInfillerRules";
    public static final String FILLER_WINDOW = "fillerWindow";
    public static final String MAX_FILLER_LENGTH = "maxFillerLength";
    public static final int DEFAULT_MAX_EXPAND_RULES = 50;
    public static final int DEFAULT_MAX_INFILLER_RULES = 10;
    public static final int DEFAULT_FILLER_WINDOW = 5;
    public static final int DEFAULT_MAX_FILLER_LENGTH = 3;
    private int fillerWindow;
    private int maxFillerLength;
    private int maxInfillerRules;
    private int maxExpandRules;
    private Map<String, List<KEPRule>> ruleLists = new HashMap<String, List<KEPRule>>();
    private Map<String, List<KEPRule>> correctionRules = new HashMap<String, List<KEPRule>>();
    private Map<String, List<TextRulerExample>> coveredExamples = new HashMap<String, List<TextRulerExample>>();
    private Map<String, Type> blocks = new HashMap<String, Type>();
    private String[] slotNamesWithBoundaries;
    private Map<String, Boolean> hasPerfectRules = new HashMap<String, Boolean>();

    public KEPLearner(String inputDir, String prePropTMFile, String tmpDir, String[] slotNames, Set<String> filterSet, boolean skip, TextRulerLearnerDelegate delegate) {
        super(inputDir, prePropTMFile, tmpDir, slotNames, filterSet, skip, delegate);
        this.supportBoundaries = true;
    }

    @Override
    protected void doRun() {
        int i;
        long startTime = System.nanoTime();
        this.exampleDocuments.clearCurrentExamples();
        this.prepareCachedCASesWithBoundaries();
        this.slotNamesWithBoundaries = new String[this.slotNames.length * 3];
        for (i = 0; i < this.slotNames.length; ++i) {
            this.slotNamesWithBoundaries[i * 3] = this.slotNames[i] + "START";
            this.slotNamesWithBoundaries[i * 3 + 1] = this.slotNames[i] + "END";
            this.slotNamesWithBoundaries[i * 3 + 2] = this.slotNames[i];
        }
        for (i = 0; i < this.slotNamesWithBoundaries.length; ++i) {
            if (!this.filterSetWithSlotNames.contains(this.slotNamesWithBoundaries[i])) {
                this.filterSetWithSlotNames.add(this.slotNamesWithBoundaries[i]);
            }
            this.initializeMapEntries(this.slotNamesWithBoundaries[i]);
        }
        for (i = 0; i < this.slotNamesWithBoundaries.length; ++i) {
            String currentSlot = this.slotNamesWithBoundaries[i];
            if (this.isCompleteSlot(currentSlot) && this.hasPerfectRules.get(this.slotNamesWithBoundaries[i - 1]).booleanValue() && this.hasPerfectRules.get(this.slotNamesWithBoundaries[i - 2]).booleanValue()) {
                this.filterSetWithSlotNames.remove(this.slotNamesWithBoundaries[i]);
                continue;
            }
            this.runForSlot(currentSlot);
            if (this.hasPerfectRules.get(currentSlot).booleanValue()) {
                this.filterSetWithSlotNames.remove(currentSlot);
            }
            if (!this.shouldAbort()) continue;
            return;
        }
        this.removeBadRules();
        for (i = 0; i < this.slotNamesWithBoundaries.length; ++i) {
            List<KEPRule> list = this.ruleLists.get(this.slotNamesWithBoundaries[i]);
            if (this.shouldAbort() || list == null || list.isEmpty()) continue;
            this.exampleDocuments.createExamplesForTarget(list.get(0).getTarget());
            if (!this.hasPerfectRules.get(this.slotNamesWithBoundaries[i]).booleanValue()) {
                this.makeRemovalRules(list.get(0).getTarget());
            }
            list = this.getOptimalRuleCombination(list);
        }
        this.removeBadRules();
        long estimatedTime = (System.nanoTime() - startTime) / 1000000000L;
        System.out.println(estimatedTime + " seconds needed to learn all rules");
        this.sendStatusUpdateToDelegate("Done", TextRulerLearner.TextRulerLearnerState.ML_DONE, true);
    }

    private boolean isCompleteSlot(String slot) {
        return !slot.endsWith("END") && !slot.endsWith("START");
    }

    private void runForSlot(String slotName) {
        this.sendStatusUpdateToDelegate("Working on " + slotName, TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        TextRulerTarget target = new TextRulerTarget(slotName, TextRulerTarget.MLTargetType.SINGLE_WHOLE_SLOT, this);
        this.exampleDocuments.createExamplesForTarget(target);
        if (!this.shouldAbort()) {
            this.blocks.put(slotName, this.getBlocks());
        }
        if (!this.shouldAbort()) {
            this.learnRules(target);
        }
        this.ruleLists.put(slotName, this.getOptimalRuleCombination(this.ruleLists.get(slotName)));
        this.sendStatusUpdateToDelegate(slotName + " done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
    }

    private Type getBlocks() {
        this.sendStatusUpdateToDelegate("Searching for Blocks", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        HashMap exampleMap = new HashMap();
        HashMap<String, Double> lengthMap = new HashMap<String, Double>();
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (TextRulerExampleDocument textRulerExampleDocument : this.exampleDocuments.getDocuments()) {
            for (Object annotation : textRulerExampleDocument.getCAS().getAnnotationIndex()) {
                for (TextRulerExample example : textRulerExampleDocument.getPositiveExamples()) {
                    if (annotation.getBegin() > example.getAnnotation().getBegin() || annotation.getEnd() < example.getAnnotation().getEnd() || annotation.getEnd() - annotation.getBegin() <= example.getAnnotation().getEnd() - example.getAnnotation().getBegin() || this.filterSetWithSlotNames.contains(annotation.getType().getName())) continue;
                    ArrayList<TextRulerExample> list = (ArrayList<TextRulerExample>)exampleMap.get(annotation.getType().getName());
                    if (list == null) {
                        list = new ArrayList<TextRulerExample>();
                    }
                    if (!list.contains(example)) {
                        list.add(example);
                    }
                    exampleMap.put(annotation.getType().getName(), list);
                }
                double aLength = annotation.getEnd() - annotation.getBegin();
                lengthMap.put(annotation.getType().getName(), lengthMap.get(annotation.getType().getName()) == null ? aLength : (Double)lengthMap.get(annotation.getType().getName()) + aLength);
                countMap.put(annotation.getType().getName(), countMap.get(annotation.getType().getName()) == null ? 1 : (Integer)countMap.get(annotation.getType().getName()) + 1);
            }
        }
        ArrayList<Type> result = new ArrayList<Type>();
        for (String typeString : exampleMap.keySet()) {
            if (((List)exampleMap.get(typeString)).size() != this.exampleDocuments.getAllPositiveExamples().size()) continue;
            result.add(this.exampleDocuments.getDocuments().get(0).getCAS().getTypeSystem().getType(typeString));
        }
        double d = 0.0;
        for (TextRulerExample ex : this.exampleDocuments.getAllPositiveExamples()) {
            d += (double)(ex.getAnnotation().getEnd() - ex.getAnnotation().getBegin());
        }
        double bestRatio = 0.0;
        Type bestType = null;
        for (Type type : result) {
            if (!(d / (Double)lengthMap.get(type.getName()) > bestRatio && (Integer)countMap.get(type.getName()) <= this.exampleDocuments.getAllPositiveExamples().size()) && (d / (Double)lengthMap.get(type.getName()) != bestRatio || (Integer)countMap.get(type.getName()) <= (Integer)countMap.get(bestType.getName()) || (Integer)countMap.get(type.getName()) > this.exampleDocuments.getAllPositiveExamples().size())) continue;
            bestType = type;
            bestRatio = d / (Double)lengthMap.get(type.getName());
        }
        this.sendStatusUpdateToDelegate("Searching for Blocks done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        return bestType;
    }

    private void learnRules(TextRulerTarget target) {
        List<KEPRule> ruleList = this.ruleLists.get(target.getSingleSlotTypeName());
        List<TextRulerExample> coveredExamples = this.coveredExamples.get(target.getSingleSlotTypeName());
        List<TextRulerExample> positiveExamples = this.exampleDocuments.getAllPositiveExamples();
        for (TextRulerExample e : positiveExamples) {
            if (!coveredExamples.contains(e)) {
                ruleList.addAll(this.makeInFillerRulesForExample(e));
            }
            for (KEPRule rule : ruleList) {
                for (TextRulerExample ex : rule.getCoveringStatistics().getCoveredPositiveExamples()) {
                    if (coveredExamples.contains(ex)) continue;
                    coveredExamples.add(ex);
                }
            }
            if (!this.shouldAbort()) continue;
            return;
        }
        ruleList.addAll(this.getCandidateClassificationRules(target));
        ruleList = this.getBestAndOptimalRules(ruleList);
        ruleList.addAll(this.makePostFillers(ruleList, true));
        ruleList = this.getOptimalRuleCombination(ruleList);
        this.ruleLists.put(target.getSingleSlotTypeName(), ruleList);
    }

    private List<KEPRule> makeInFillerRulesForExample(TextRulerExample e) {
        this.sendStatusUpdateToDelegate("Searching for Infiller Rules for " + e.getTarget().getSingleSlotTypeName().substring(e.getTarget().getSingleSlotTypeName().lastIndexOf(".") + 1), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        Collection<KEPRule> rules = new HashSet<KEPRule>();
        rules = new HashSet();
        rules = this.expandInFillerRules(e, rules, true);
        if (rules.size() > this.maxInfillerRules) {
            ArrayList<KEPRule> list = new ArrayList<KEPRule>(rules);
            Collections.sort(list, new KEPRuleComparator(e.getDocumentCAS()));
            rules = new HashSet(list.subList(0, this.maxInfillerRules));
        }
        ArrayList<KEPRule> result = new ArrayList<KEPRule>(rules);
        if (this.shouldAbort()) {
            return result;
        }
        this.testRulesOnDocumentSet(result, this.exampleDocuments);
        this.sendStatusUpdateToDelegate("Searching for Infiller Rules for " + e.getTarget().getSingleSlotTypeName().substring(e.getTarget().getSingleSlotTypeName().lastIndexOf(".") + 1) + " done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        return new ArrayList<KEPRule>(rules);
    }

    private Collection<KEPRule> expandInFillerRules(TextRulerExample e, Collection<KEPRule> rules, boolean expanding) {
        if (rules.size() > this.maxExpandRules) {
            ArrayList<KEPRule> list = new ArrayList<KEPRule>(rules);
            Collections.sort(list, new KEPRuleComparator(e.getDocumentCAS()));
            rules = new HashSet<KEPRule>(list.subList(0, this.maxExpandRules));
        }
        if (!expanding) {
            return rules;
        }
        HashSet<KEPRule> expandedRules = new HashSet<KEPRule>();
        if (rules.isEmpty()) {
            List<AnnotationFS> seeds = this.getAnnotationsStartingAt(e.getDocumentCAS(), e.getAnnotation().getBegin(), e.getAnnotation().getEnd());
            if (seeds.isEmpty()) {
                expanding = false;
            }
            for (AnnotationFS each : seeds) {
                KEPRuleItem item = new KEPRuleItem(each);
                KEPRule rule = new KEPRule(this, e.getTarget());
                rule.addInFillerItem(item);
                expandedRules.add(rule);
            }
        } else {
            expanding = false;
            for (KEPRule eachRule : rules) {
                TextRulerRulePattern inFiller = eachRule.getInFiller();
                KEPRuleItem lastItem = (KEPRuleItem)inFiller.get(inFiller.size() - 1);
                int end = lastItem.getEnd();
                if (end >= e.getAnnotation().getEnd()) {
                    if (expandedRules.contains(eachRule)) continue;
                    expandedRules.add(eachRule);
                    continue;
                }
                List<AnnotationFS> annotationsStartingAt = this.getAnnotationsStartingAt(e.getDocumentCAS(), end, e.getAnnotation().getEnd());
                if (annotationsStartingAt.isEmpty() && !expandedRules.contains(eachRule)) {
                    expandedRules.add(eachRule);
                    continue;
                }
                expanding = true;
                for (AnnotationFS eachFS : annotationsStartingAt) {
                    if (eachFS.getType().getName().equals(lastItem.getType().getName())) {
                        lastItem.setAnnotation(eachFS);
                        lastItem.setMax(lastItem.getMax() + 1).setReluctant(true);
                        expandedRules.add(eachRule);
                        continue;
                    }
                    KEPRule newRule = new KEPRule(eachRule);
                    KEPRuleItem newItem = new KEPRuleItem(eachFS);
                    newRule.addInFillerItem(newItem);
                    expandedRules.add(newRule);
                }
            }
        }
        return this.expandInFillerRules(e, expandedRules, expanding);
    }

    private List<KEPRule> getCandidateClassificationRules(TextRulerTarget target) {
        this.sendStatusUpdateToDelegate("Searching for Candidate Classification Rules for " + target.getSingleSlotTypeName().substring(target.getSingleSlotTypeName().lastIndexOf(".") + 1), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        List<KEPRule> result = new ArrayList<KEPRule>();
        List<Type> types = this.getTokensInNExamples(this.exampleDocuments.getAllPositiveExamples(), this.exampleDocuments.getAllPositiveExamples().size() / 2, true);
        for (Type type : types) {
            result.add(new KEPRule(this, target).addInFillerItem(new KEPRuleItem(type)));
        }
        this.testRulesOnDocumentSet(result, this.exampleDocuments);
        result = this.addConditions(result, target);
        this.sendStatusUpdateToDelegate("Searching for Candidate Classification Rules for " + target.getSingleSlotTypeName().substring(target.getSingleSlotTypeName().lastIndexOf(".") + 1) + " done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        return result;
    }

    private List<KEPRule> addConditions(List<KEPRule> rules, TextRulerTarget target) {
        List<KEPRule> result = new ArrayList<KEPRule>();
        List<TextRulerExample> allCoveredExamples = this.getCoveredExamples(rules);
        List<Type> containedTypes = this.getTokensInNExamples(this.exampleDocuments.getAllPositiveExamples(), this.exampleDocuments.getAllPositiveExamples().size() / 3, false);
        if (!containedTypes.isEmpty()) {
            for (KEPRule rule : rules) {
                KEPRuleItem ruleItem = (KEPRuleItem)rule.getInFiller().get(0);
                for (Type type : containedTypes) {
                    if (type.getName().equals(ruleItem.getType().getName()) || ruleItem.containsAndCondition(type)) continue;
                    result.add(new KEPRule(this, target).addInFillerItem(ruleItem.copy().addAndCondition(new KEPRuleItemCondition(type, KEPRuleItemCondition.Condition.CONTAINS, false))));
                }
            }
        }
        this.testRulesOnDocumentSet(result, this.exampleDocuments);
        result = this.getBestAndOptimalRules(result);
        ArrayList<KEPRule> toRefine = new ArrayList<KEPRule>();
        ArrayList<KEPRule> toRemove = new ArrayList<KEPRule>();
        for (KEPRule rule : result) {
            if (rule.getCoveringStatistics().getCoveredPositivesCount() == 0) {
                toRemove.add(rule);
                continue;
            }
            if (rule.getCoveringStatistics().getCoveredNegativesCount() <= 0 || rule.getPostFiller().size() >= 5) continue;
            toRefine.add(rule);
        }
        result.removeAll(toRemove);
        result.removeAll(toRefine);
        result = this.getBestAndOptimalRules(result);
        if (this.getCoveredExamples(result).size() == allCoveredExamples.size()) {
            return result;
        }
        if (toRefine.size() > 0) {
            result.addAll(this.addConditions(toRefine, target));
        }
        this.sendStatusUpdateToDelegate("Adding conditions to rules for " + target.getSingleSlotTypeName().substring(target.getSingleSlotTypeName().lastIndexOf(".") + 1) + " done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        return result;
    }

    private List<KEPRule> makePostFillers(List<KEPRule> baseRules, boolean changed) {
        if (baseRules.isEmpty() || this.shouldAbort()) {
            return new ArrayList<KEPRule>();
        }
        this.sendStatusUpdateToDelegate("Adding postfillers to rules for " + baseRules.get(0).getTarget().getSingleSlotTypeName().substring(baseRules.get(0).getTarget().getSingleSlotTypeName().lastIndexOf(".") + 1), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        HashSet<KEPRule> result = new HashSet<KEPRule>();
        for (KEPRule rule : baseRules) {
            for (TextRulerExample e : rule.getCoveringStatistics().getCoveredPositiveExamples()) {
                if (rule.getCoveringStatistics().getCoveredNegativesCount() > 0) {
                    KEPRuleItem lastItem = (KEPRuleItem)rule.getPostFiller().lastItem();
                    int end = e.getAnnotation().getEnd();
                    if (lastItem != null) {
                        end = lastItem.getEnd();
                    }
                    List<AnnotationFS> annotations = this.getAnnotationsStartingAt(e.getDocumentCAS(), end, e.getDocumentCAS().getDocumentText().length());
                    boolean blockBoundaryHit = false;
                    for (AnnotationFS annotationFS : annotations) {
                        if (!annotationFS.getType().equals(this.blocks.get(baseRules.get(0).getTarget().getSingleSlotTypeName()))) continue;
                        blockBoundaryHit = true;
                        break;
                    }
                    if (blockBoundaryHit) continue;
                    for (AnnotationFS annotationFS : annotations) {
                        if (annotationFS.getType().getName().equals(lastItem != null ? lastItem.getType().getName() : null)) {
                            lastItem.setReluctant(true).setMax(lastItem.getMax() + 1).setAnnotation(annotationFS);
                        } else {
                            result.add(rule.copy().addPostFillerItem(new KEPRuleItem(annotationFS)));
                        }
                        if (!rule.getPreFiller().isEmpty()) continue;
                        result.add(rule);
                    }
                    continue;
                }
                result.add(rule);
            }
        }
        List<KEPRule> resultList = new ArrayList<KEPRule>(result);
        this.testRulesOnDocumentSet(resultList, this.exampleDocuments);
        resultList.addAll(baseRules);
        resultList = this.getBestAndOptimalRules(resultList);
        if (baseRules.containsAll(resultList)) {
            if (!changed) {
                return resultList;
            }
            changed = false;
        } else {
            changed = true;
        }
        resultList.addAll(this.makePreFillers(resultList, changed));
        this.sendStatusUpdateToDelegate("Adding postfillers to rules for " + baseRules.get(0).getTarget().getSingleSlotTypeName().substring(baseRules.get(0).getTarget().getSingleSlotTypeName().lastIndexOf(".") + 1) + " done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        return resultList;
    }

    private List<KEPRule> makePreFillers(List<KEPRule> baseRules, boolean changed) {
        if (baseRules.isEmpty() || this.shouldAbort()) {
            return new ArrayList<KEPRule>();
        }
        this.sendStatusUpdateToDelegate("Adding prefillers to rules for " + baseRules.get(0).getTarget().getSingleSlotTypeName().substring(baseRules.get(0).getTarget().getSingleSlotTypeName().lastIndexOf(".") + 1), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        HashSet<KEPRule> result = new HashSet<KEPRule>();
        for (KEPRule rule : baseRules) {
            for (TextRulerExample e : rule.getCoveringStatistics().getCoveredPositiveExamples()) {
                if (rule.getCoveringStatistics().getCoveredNegativesCount() > 0) {
                    int begin = e.getAnnotation().getBegin();
                    KEPRuleItem firstItem = (KEPRuleItem)rule.getPreFiller().firstItem();
                    if (firstItem != null) {
                        begin = firstItem.getBegin();
                    }
                    List<AnnotationFS> annotations = this.getAnnotationsEndingAt(begin, e.getDocumentCAS());
                    boolean blockBoundaryHit = false;
                    for (AnnotationFS annotationFS : annotations) {
                        if (!annotationFS.getType().equals(this.blocks.get(baseRules.get(0).getTarget().getSingleSlotTypeName()))) continue;
                        blockBoundaryHit = true;
                        break;
                    }
                    if (blockBoundaryHit) continue;
                    for (AnnotationFS annotationFS : annotations) {
                        if (annotationFS.getType().getName().equals(firstItem != null ? firstItem.getType().getName() : null)) {
                            firstItem.setReluctant(true).setMax(firstItem.getMax() + 1).setAnnotation(annotationFS);
                            continue;
                        }
                        result.add(rule.copy().addPreFillerItem(new KEPRuleItem(annotationFS)));
                    }
                    continue;
                }
                result.add(rule);
            }
        }
        List<KEPRule> resultList = new ArrayList<KEPRule>(result);
        this.testRulesOnDocumentSet(resultList, this.exampleDocuments);
        resultList.addAll(baseRules);
        resultList = this.getBestAndOptimalRules(resultList);
        if (baseRules.containsAll(resultList)) {
            if (!changed) {
                return resultList;
            }
            changed = false;
        } else {
            changed = true;
        }
        resultList.addAll(this.makePostFillers(resultList, changed));
        this.sendStatusUpdateToDelegate("Adding prefillers to rules for " + baseRules.get(0).getTarget().getSingleSlotTypeName().substring(baseRules.get(0).getTarget().getSingleSlotTypeName().lastIndexOf(".") + 1) + " done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        return resultList;
    }

    private void removeBadRules() {
        for (int i = 0; i < this.slotNames.length; ++i) {
            ArrayList<TextRulerExample> exList;
            ArrayList<KEPRule> list;
            if (!this.hasPerfectRules.get(this.slotNames[i]).booleanValue() && this.hasPerfectRules.get(this.slotNamesWithBoundaries[3 * i + 1]).booleanValue() && this.hasPerfectRules.get(this.slotNamesWithBoundaries[3 * i + 2]).booleanValue()) {
                list = new ArrayList();
                for (KEPRule kepRule : this.ruleLists.get(this.slotNames[i])) {
                    exList = new ArrayList<TextRulerExample>(kepRule.getCoveringStatistics().getCoveredNegativeExamples());
                    exList.removeAll(this.getCorrectedExamples(this.slotNames[i]));
                    if (exList.size() != 0) continue;
                    list.add(kepRule);
                }
                this.ruleLists.put(this.slotNames[i], list);
                continue;
            }
            if (!this.hasPerfectRules.get(this.slotNamesWithBoundaries[3 * i + 1]).booleanValue()) {
                list = new ArrayList<KEPRule>();
                for (KEPRule kepRule : this.ruleLists.get(this.slotNamesWithBoundaries[3 * i + 1])) {
                    exList = new ArrayList<TextRulerExample>(kepRule.getCoveringStatistics().getCoveredNegativeExamples());
                    exList.removeAll(this.getCorrectedExamples(this.slotNamesWithBoundaries[3 * i + 1]));
                    if (exList.size() != 0) continue;
                    list.add(kepRule);
                }
            }
            if (this.hasPerfectRules.get(this.slotNamesWithBoundaries[3 * i + 2]).booleanValue()) continue;
            list = new ArrayList();
            for (KEPRule kepRule : this.ruleLists.get(this.slotNamesWithBoundaries[3 * i + 2])) {
                exList = new ArrayList<TextRulerExample>(kepRule.getCoveringStatistics().getCoveredNegativeExamples());
                exList.removeAll(this.getCorrectedExamples(this.slotNamesWithBoundaries[3 * i + 2]));
                if (exList.size() != 0) continue;
                list.add(kepRule);
            }
        }
    }

    private List<KEPRule> makeRemovalRules(TextRulerTarget target) {
        this.sendStatusUpdateToDelegate("Searching for Removal Rules for " + target.getSingleSlotTypeName().substring(target.getSingleSlotTypeName().lastIndexOf(".") + 1), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        if (!this.hasFalsePositives(target.getSingleSlotTypeName())) {
            return new ArrayList<KEPRule>();
        }
        List<KEPRule> result = this.correctionRules.get(target.getSingleSlotTypeName());
        Type targetType = this.exampleDocuments.getDocuments().get(0).getCAS().getTypeSystem().getType(target.getSingleSlotTypeName());
        List<Type> containedTypes = this.getTokensInNExamples(this.exampleDocuments.getAllPositiveExamples(), this.exampleDocuments.getAllPositiveExamples().size(), false);
        List<Type> notContainedTypes = this.getTokensInNoExample(this.exampleDocuments.getAllPositiveExamples());
        if (!containedTypes.isEmpty()) {
            KEPRuleItem containsRuleItem = new KEPRuleItem(targetType);
            for (Type type : containedTypes) {
                result.add(new KEPRule(this, target).addInFillerItem(containsRuleItem.copy().addAndCondition(new KEPRuleItemCondition(type, KEPRuleItemCondition.Condition.CONTAINS, true))).setCorrectionRule(true));
            }
        }
        if (!notContainedTypes.isEmpty()) {
            KEPRuleItem notContainsRuleItem = new KEPRuleItem(targetType);
            for (Type type : notContainedTypes) {
                result.add(new KEPRule(this, target).addInFillerItem(notContainsRuleItem.copy().addAndCondition(new KEPRuleItemCondition(type, KEPRuleItemCondition.Condition.CONTAINS, false))).setCorrectionRule(true));
            }
        }
        this.testCorrectionRules(target);
        ArrayList<KEPRule> toRemove = new ArrayList<KEPRule>();
        ArrayList<KEPRuleItemCondition> toMerge = new ArrayList<KEPRuleItemCondition>();
        for (KEPRule rule : result) {
            if (rule.getCoveringStatistics().getCoveredPositivesCount() != 0 || rule.getCoveringStatistics().getCoveredNegativesCount() <= 0) {
                toRemove.add(rule);
                continue;
            }
            toMerge.addAll((Collection<KEPRuleItemCondition>)((KEPRuleItem)rule.getInFiller().get(0)).getConditions().get(0));
            toRemove.add(rule);
        }
        result.removeAll(toRemove);
        if (!toMerge.isEmpty()) {
            result.add(new KEPRule(this, target).addInFillerItem(new KEPRuleItem(targetType).addConditions(toMerge)).setCorrectionRule(true));
            this.testCorrectionRules(target);
        }
        this.sendStatusUpdateToDelegate("Searching for Removal Rules for " + target.getSingleSlotTypeName().substring(target.getSingleSlotTypeName().lastIndexOf(".") + 1) + " done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        return result;
    }

    private void initializeMapEntries(String slotName) {
        this.ruleLists.put(slotName, new ArrayList());
        this.correctionRules.put(slotName, new ArrayList());
        this.coveredExamples.put(slotName, new ArrayList());
        this.hasPerfectRules.put(slotName, false);
    }

    private List<AnnotationFS> getAnnotationsEndingAt(int end, CAS cas) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        FSIterator it = cas.getAnnotationIndex(cas.getTypeSystem().getType("org.apache.uima.ruta.type.ALL")).iterator();
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < end) {
            it.moveToNext();
        }
        do {
            it.moveToPrevious();
        } while (it.isValid() && (((AnnotationFS)it.get()).getBegin() >= end || this.filterSetWithSlotNames.contains(((AnnotationFS)it.get()).getType().getName())));
        if (!it.isValid()) {
            return result;
        }
        end = ((AnnotationFS)it.get()).getEnd();
        it = cas.getAnnotationIndex().iterator();
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() <= end) {
            if (((AnnotationFS)it.get()).getEnd() == end && !this.filterSetWithSlotNames.contains(((AnnotationFS)it.get()).getType().getName())) {
                result.add((AnnotationFS)it.get());
            }
            it.moveToNext();
        }
        return result;
    }

    private List<AnnotationFS> getAnnotationsStartingAt(CAS cas, int begin, int till) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        if (begin > cas.getDocumentText().length()) {
            return new ArrayList<AnnotationFS>();
        }
        if (begin == 0) {
            ++begin;
        }
        AnnotationFS pointer = cas.createAnnotation(cas.getAnnotationType(), begin - 1, begin);
        FSIterator it = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        FSMatchConstraint constraint = this.getConstraint(cas);
        FSIterator iterator = cas.createFilteredIterator(it, constraint);
        iterator.moveTo((FeatureStructure)pointer);
        int firstBegin = -1;
        while (iterator.isValid()) {
            AnnotationFS fs = (AnnotationFS)iterator.get();
            if (firstBegin == -1 && fs.getBegin() >= begin) {
                firstBegin = fs.getBegin();
            }
            if (firstBegin >= 0) {
                if (fs.getBegin() > firstBegin) break;
                if (fs.getBegin() == firstBegin && fs.getEnd() <= till && !this.filterSetWithSlotNames.contains(fs.getType().getName())) {
                    result.add(fs);
                }
            }
            iterator.moveToNext();
        }
        return result;
    }

    private List<KEPRule> getOptimalRuleCombination(List<KEPRule> rules) {
        if (rules.isEmpty()) {
            return new ArrayList<KEPRule>();
        }
        List<KEPRule> tmpList = new ArrayList<KEPRule>();
        ArrayList<TextRulerExample> coveredExamples = new ArrayList<TextRulerExample>();
        List<TextRulerExample> positiveExamples = this.exampleDocuments.getAllPositiveExamples();
        List<TextRulerExample> correctedExamples = this.getCorrectedExamples(rules.get(0).getTarget().getSingleSlotTypeName());
        for (KEPRule rule : rules) {
            ArrayList<TextRulerExample> uncorrectedExamples = new ArrayList<TextRulerExample>(rule.getCoveringStatistics().getCoveredNegativeExamples());
            uncorrectedExamples.removeAll(correctedExamples);
            if (uncorrectedExamples.size() != 0 || rule.getCoveringStatistics().getCoveredPositivesCount() <= 0) continue;
            tmpList.add(rule);
        }
        tmpList = this.getBestRules(tmpList);
        for (KEPRule rule : tmpList) {
            coveredExamples.addAll(rule.getCoveringStatistics().getCoveredPositiveExamples());
        }
        if (coveredExamples.containsAll(this.exampleDocuments.getAllPositiveExamples())) {
            this.hasPerfectRules.put(rules.get(0).getTarget().getSingleSlotTypeName(), true);
        } else {
            this.hasPerfectRules.put(rules.get(0).getTarget().getSingleSlotTypeName(), false);
        }
        List<KEPRule> bestRules = this.getBestRules(rules);
        while (!coveredExamples.containsAll(positiveExamples) && !bestRules.isEmpty()) {
            KEPRule bestRule = bestRules.get(0);
            if (!coveredExamples.containsAll(bestRule.getCoveringStatistics().getCoveredPositiveExamples())) {
                coveredExamples.removeAll(bestRule.getCoveringStatistics().getCoveredPositiveExamples());
                coveredExamples.addAll(bestRule.getCoveringStatistics().getCoveredPositiveExamples());
                tmpList.add(bestRule);
            }
            bestRules.remove(0);
        }
        return tmpList;
    }

    private List<KEPRule> getBestRules(List<KEPRule> rules) {
        KEPRule rule;
        int i;
        if (rules.isEmpty()) {
            return new ArrayList<KEPRule>();
        }
        final class AComparator
        implements Comparator<KEPRule> {
            AComparator() {
            }

            @Override
            public int compare(KEPRule r1, KEPRule r2) {
                if (r1.getCoveringStatistics().getCoveredPositivesCount() < r2.getCoveringStatistics().getCoveredPositivesCount()) {
                    return 1;
                }
                if (r1.getCoveringStatistics().getCoveredPositivesCount() > r2.getCoveringStatistics().getCoveredPositivesCount()) {
                    return -1;
                }
                if (r1.getCoveringStatistics().getCoveredNegativesCount() > r2.getCoveringStatistics().getCoveredNegativesCount()) {
                    return 1;
                }
                if (r1.getCoveringStatistics().getCoveredNegativesCount() < r2.getCoveringStatistics().getCoveredNegativesCount()) {
                    return -1;
                }
                if (r1.getPreFiller().size() + r1.getInFiller().size() + r1.getPostFiller().size() < r2.getPreFiller().size() + r2.getInFiller().size() + r2.getPostFiller().size()) {
                    return -1;
                }
                return 0;
            }
        }
        Collections.sort(rules, new AComparator());
        ArrayList<KEPRule> result = new ArrayList<KEPRule>();
        List<TextRulerExample> positiveExamples = this.exampleDocuments.getAllPositiveExamples();
        ArrayList<TextRulerExample> coveredExamples = new ArrayList<TextRulerExample>();
        for (i = 0; i < rules.size(); ++i) {
            rule = rules.get(i);
            if (3 * rule.getCoveringStatistics().getCoveredPositivesCount() < rule.getCoveringStatistics().getCoveredNegativesCount() || rule.getCoveringStatistics().getCoveredPositivesCount() < positiveExamples.size() && coveredExamples.containsAll(rule.getCoveringStatistics().getCoveredPositiveExamples())) continue;
            result.add(rule);
            coveredExamples.addAll(rule.getCoveringStatistics().getCoveredPositiveExamples());
            if (!coveredExamples.containsAll(positiveExamples)) continue;
            return result;
        }
        for (i = 0; i < rules.size(); ++i) {
            rule = rules.get(i);
            if (rule.getCoveringStatistics().getCoveredPositivesCount() < positiveExamples.size() && coveredExamples.containsAll(rule.getCoveringStatistics().getCoveredPositiveExamples())) continue;
            result.add(rule);
            coveredExamples.addAll(rule.getCoveringStatistics().getCoveredPositiveExamples());
            if (!coveredExamples.containsAll(positiveExamples)) continue;
            return result;
        }
        return result;
    }

    private List<KEPRule> getBestAndOptimalRules(List<KEPRule> rules) {
        ArrayList<KEPRule> result = new ArrayList<KEPRule>();
        result.addAll(this.getBestRules(rules));
        List<KEPRule> tmp = this.getOptimalRuleCombination(rules);
        for (KEPRule rule : tmp) {
            if (result.contains(rule)) continue;
            result.add(rule);
        }
        return result;
    }

    private List<Type> getTokensInNExamples(List<TextRulerExample> examples, int n, boolean countOnlyCoveringTokens) {
        if (examples.isEmpty()) {
            return new ArrayList<Type>();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        HashMap countMap = new HashMap();
        for (TextRulerExample example : examples) {
            for (AnnotationFS a : TextRulerToolkit.getAnnotationsWithinBounds(example.getDocumentCAS(), example.getAnnotation().getBegin(), example.getAnnotation().getEnd(), this.filterSetWithSlotNames, null)) {
                if (this.filterSetWithSlotNames.contains(a.getType().getName()) || (countOnlyCoveringTokens || a.getBegin() < example.getAnnotation().getBegin() || a.getEnd() > example.getAnnotation().getEnd()) && (a.getBegin() != example.getAnnotation().getBegin() || a.getEnd() != example.getAnnotation().getEnd())) continue;
                ArrayList<TextRulerExample> list = (ArrayList<TextRulerExample>)countMap.get(a.getType().getName());
                if (list == null) {
                    list = new ArrayList<TextRulerExample>();
                    list.add(example);
                } else if (!list.contains(example)) {
                    list.add(example);
                }
                countMap.put(a.getType().getName(), list);
            }
        }
        for (String typeString : countMap.keySet()) {
            if (((List)countMap.get(typeString)).size() < n) continue;
            result.add(examples.get(0).getDocumentCAS().getTypeSystem().getType(typeString));
        }
        return result;
    }

    private List<Type> getTokensInNoExample(List<TextRulerExample> examples) {
        ArrayList<String> types = new ArrayList<String>();
        for (TextRulerExampleDocument textRulerExampleDocument : this.exampleDocuments.getDocuments()) {
            for (AnnotationFS a : textRulerExampleDocument.getCAS().getAnnotationIndex()) {
                if (types.contains(a.getType().getName()) || this.filterSetWithSlotNames.contains(a.getType().getName())) continue;
                types.add(a.getType().getName());
            }
        }
        List<Type> containedTypes = this.getTokensInNExamples(examples, 1, false);
        for (Type type : containedTypes) {
            types.remove(type.getName());
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (String typeString : types) {
            arrayList.add(examples.get(0).getDocumentCAS().getTypeSystem().getType(typeString));
        }
        return arrayList;
    }

    @Override
    public String getResultString() {
        StringBuffer ruleStrings = new StringBuffer();
        if (this.slotNamesWithBoundaries == null || this.slotNamesWithBoundaries.length == 0) {
            return "No results available yet!";
        }
        for (int i = 0; i < this.slotNamesWithBoundaries.length; ++i) {
            List<KEPRule> ruleList = this.ruleLists.get(this.slotNamesWithBoundaries[i]);
            Type blockType = this.blocks.get(this.slotNamesWithBoundaries[i]);
            if (!(blockType == null || i > 0 && this.blocks.get(this.slotNamesWithBoundaries[i - 1]) != null && this.blocks.get(this.slotNamesWithBoundaries[i - 1]).getName().equals(blockType.getName()))) {
                ruleStrings.append("BLOCK(" + blockType.getShortName() + ") " + blockType.getShortName() + "{} { \n");
            }
            if (ruleList == null || ruleList.isEmpty()) {
                if (blockType == null || i < this.slotNamesWithBoundaries.length - 1 && this.blocks.get(this.slotNamesWithBoundaries[i + 1]) != null && this.blocks.get(this.slotNamesWithBoundaries[i + 1]).getName().equals(blockType.getName())) continue;
                ruleStrings.append("} \n");
                continue;
            }
            ruleStrings.append("// " + this.slotNamesWithBoundaries[i] + " RULES \n");
            for (KEPRule rule : new ArrayList<KEPRule>(ruleList)) {
                ruleStrings.append((blockType != null ? "\t" : "") + rule.getRuleString() + "\t// " + rule.getCoveringStatistics() + "\n");
            }
            if (!(blockType == null || i < this.slotNamesWithBoundaries.length - 1 && this.blocks.get(this.slotNamesWithBoundaries[i + 1]) != null && this.blocks.get(this.slotNamesWithBoundaries[i + 1]).getName().equals(blockType.getName()))) {
                ruleStrings.append("}");
            }
            ruleStrings.append("\n");
        }
        StringBuffer boundaryCorrectors = new StringBuffer();
        StringBuffer wholeSlotCorrectors = new StringBuffer();
        boundaryCorrectors.append("\n // BOUNDARY CORRECTION RULES: \n");
        wholeSlotCorrectors.append("\n // CORRECTION RULES: \n");
        for (int i = 0; i < this.slotNamesWithBoundaries.length; ++i) {
            List<KEPRule> ruleList = this.correctionRules.get(this.slotNamesWithBoundaries[i]);
            if (ruleList == null || ruleList.isEmpty()) continue;
            for (KEPRule rule : ruleList) {
                if (this.slotNamesWithBoundaries[i].contains("START") || this.slotNamesWithBoundaries[i].contains("END")) {
                    boundaryCorrectors.append(rule.getRuleString() + "\t// " + rule.getCoveringStatistics() + "\n");
                    continue;
                }
                wholeSlotCorrectors.append(rule.getRuleString() + "\t// " + rule.getCoveringStatistics() + "\n");
            }
        }
        return this.getFileHeaderString(true) + ruleStrings + boundaryCorrectors + "\n // CONNECTORS: \n" + this.getConnectorsRuleString() + wholeSlotCorrectors;
    }

    private String getAnnotationRulesString(String slotName) {
        List<KEPRule> ruleList;
        StringBuffer result = new StringBuffer();
        result.append(this.getPackageString());
        result.append("// " + slotName + " RULES \n");
        Type blockType = this.blocks.get(slotName);
        if (blockType != null) {
            result.append("BLOCK(" + blockType.getShortName() + ") " + blockType.getShortName() + "{} { \n");
        }
        if ((ruleList = this.ruleLists.get(slotName)) != null && !ruleList.isEmpty()) {
            for (KEPRule rule : ruleList) {
                String theRuleString = rule.getRuleString();
                result.append((blockType != null ? "\t" : "") + theRuleString + "\t// " + rule.getCoveringStatistics() + "\n");
            }
        }
        if (blockType != null) {
            result.append("}");
        }
        result.append("\n");
        if (!slotName.contains("START") && !slotName.contains("END")) {
            result.append(this.getAnnotationRulesString(slotName + "START"));
            result.append(this.getAnnotationRulesString(slotName + "END"));
            if (blockType != null) {
                result.append("BLOCK(" + blockType.getShortName() + "Correction) " + blockType.getShortName() + "{} { \n");
            }
            String shortName = slotName.substring(slotName.lastIndexOf(".") + 1);
            String str = shortName + "START" + "{->MARKONCE(" + shortName + ",1,3)} ANY*? " + shortName + "END" + ";\n";
            str = str + shortName + "START" + "{IS(" + shortName + "END" + ")->MARKONCE(" + shortName + ")} ;\n";
            result.append(str);
            if (blockType != null) {
                result.append("}");
            }
        }
        return result.toString();
    }

    private String getConnectorsRuleString() {
        HashMap<Type, StringBuffer> connectorBlocks = new HashMap<Type, StringBuffer>();
        StringBuffer noBlockConnectorRules = new StringBuffer();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.slotNames.length; ++i) {
            Type slotBlock = this.blocks.get(this.slotNames[i]);
            String shortName = this.slotNames[i].substring(this.slotNames[i].lastIndexOf(".") + 1);
            String str = (slotBlock == null ? "" : "\t") + shortName + "START" + "{->MARKONCE(" + shortName + ",1,3)} ANY*? " + shortName + "END" + ";\n";
            str = str + (slotBlock == null ? "" : "\t") + shortName + "START" + "{IS(" + shortName + "END" + ")->MARKONCE(" + shortName + ")} ;\n";
            if (slotBlock != null) {
                if (connectorBlocks.get(slotBlock) == null) {
                    connectorBlocks.put(slotBlock, new StringBuffer());
                }
                ((StringBuffer)connectorBlocks.get(slotBlock)).append(str);
                continue;
            }
            noBlockConnectorRules.append(str);
        }
        for (Type block : connectorBlocks.keySet()) {
            result.append("BLOCK(" + block.getShortName() + "Connectors) " + block.getShortName() + "{} { \n" + connectorBlocks.get(block) + "} \n");
        }
        result.append(noBlockConnectorRules);
        return result.toString();
    }

    private List<TextRulerExample> getCoveredExamples(List<KEPRule> rules) {
        ArrayList<TextRulerExample> result = new ArrayList<TextRulerExample>();
        for (KEPRule rule : rules) {
            for (TextRulerExample ex : rule.getCoveringStatistics().getCoveredPositiveExamples()) {
                if (result.contains(ex)) continue;
                result.add(ex);
            }
        }
        return result;
    }

    private List<TextRulerExample> getCorrectedExamples(String slotName) {
        ArrayList<TextRulerExample> result = new ArrayList<TextRulerExample>();
        for (KEPRule rule : this.correctionRules.get(slotName)) {
            for (TextRulerExample ex : rule.getCoveringStatistics().getCoveredNegativeExamples()) {
                if (result.contains(ex)) continue;
                result.add(ex);
            }
        }
        return result;
    }

    private boolean hasFalsePositives(String singleSlotTypeName) {
        List<KEPRule> list = this.ruleLists.get(singleSlotTypeName);
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (KEPRule kepRule : list) {
            if (kepRule.getCoveringStatistics().getCoveredNegativesCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public void testCorrectionRules(TextRulerTarget target) {
        if (this.shouldAbort()) {
            return;
        }
        String rStr = this.getAnnotationRulesString(target.getSingleSlotTypeName());
        block0: for (TextRulerExampleDocument doc : this.exampleDocuments.getDocuments()) {
            CAS processedCAS = this.applyScriptOnDocument(rStr, doc, target);
            TextRulerStatisticsCollector scriptStatistics = new TextRulerStatisticsCollector();
            this.compareOriginalDocumentWithTestCAS(doc, processedCAS, target, scriptStatistics, this.collectNegativeCoveredInstancesWhenTesting());
            for (KEPRule cRule : this.correctionRules.get(target.getSingleSlotTypeName())) {
                if (this.shouldAbort()) continue block0;
                if (cRule.getCoveringStatistics() == null) {
                    cRule.setCoveringStatistics(new TextRulerStatisticsCollector());
                }
                processedCAS = this.applyScriptOnDocument(rStr, doc, target);
                TextRulerStatisticsCollector correctedStats = new TextRulerStatisticsCollector();
                this.testRuleOnDocument(cRule, doc, correctedStats, processedCAS);
                for (TextRulerExample ex : scriptStatistics.getCoveredNegativeExamples()) {
                    if (correctedStats.getCoveredNegativeExamples().contains(ex)) continue;
                    cRule.getCoveringStatistics().addCoveredNegative(ex);
                }
                for (TextRulerExample ex : scriptStatistics.getCoveredPositiveExamples()) {
                    if (correctedStats.getCoveredPositiveExamples().contains(ex)) continue;
                    cRule.getCoveringStatistics().addCoveredPositive(ex);
                }
                cRule.getCoveringStatistics().reflectCountsFromCoveredExamples();
            }
        }
    }

    private void prepareCASWithBoundaries(CAS cas) {
        for (String slotName : this.slotNames) {
            if (slotName.contains("START") || slotName.contains("END")) continue;
            TextRulerExampleDocument.createBoundaryAnnotationsForCas(cas, slotName, this.filterSet);
        }
    }

    @Override
    public CAS loadCAS(String fileName, CAS reuseCAS) {
        CAS cas = super.loadCAS(fileName, reuseCAS);
        this.prepareCASWithBoundaries(cas);
        return cas;
    }

    private void prepareCachedCASesWithBoundaries() {
        for (CAS cas : this.exampleDocuments.getCachedCASes()) {
            this.prepareCASWithBoundaries(cas);
        }
    }

    @Override
    public boolean collectNegativeCoveredInstancesWhenTesting() {
        return true;
    }

    @Override
    public void setParameters(Map<String, Object> params) {
        if (params.containsKey(FILLER_WINDOW)) {
            this.fillerWindow = (Integer)params.get(FILLER_WINDOW);
        }
        if (params.containsKey(MAX_EXPAND_RULES)) {
            this.maxExpandRules = (Integer)params.get(MAX_EXPAND_RULES);
        }
        if (params.containsKey(MAX_FILLER_LENGTH)) {
            this.maxFillerLength = (Integer)params.get(MAX_FILLER_LENGTH);
        }
        if (params.containsKey(MAX_INFILLER_RULES)) {
            this.maxInfillerRules = (Integer)params.get(MAX_INFILLER_RULES);
        }
    }

    protected FSMatchConstraint getConstraint(CAS cas) {
        ConstraintFactory cf = cas.getConstraintFactory();
        final FSTypeConstraint constraint = cf.createTypeConstraint();
        for (String each : this.getFilterSet()) {
            constraint.add(each);
        }
        constraint.add("org.apache.uima.ruta.type.RutaBasic");
        FSMatchConstraint result = new FSMatchConstraint(){
            private static final long serialVersionUID = -6744378612440830298L;
            private final FSTypeConstraint c;
            {
                this.c = constraint;
            }

            public boolean match(FeatureStructure fs) {
                return !this.c.match(fs);
            }
        };
        return result;
    }

    public class KEPRuleComparator
    implements Comparator<KEPRule> {
        private CAS cas;

        public KEPRuleComparator(CAS cas) {
            this.cas = cas;
        }

        @Override
        public int compare(KEPRule o1, KEPRule o2) {
            TextRulerRulePattern items1 = o1.getInFiller();
            items1.addAll(o1.getPostFiller());
            items1.addAll(o1.getPreFiller());
            double occ1 = 0.0;
            double occ2 = 0.0;
            for (Object each : items1) {
                KEPRuleItem eachItem = (KEPRuleItem)each;
                int ratio = KEPLearner.this.exampleDocuments.getAllPositiveExamples().size() / this.cas.getAnnotationIndex(eachItem.getType()).size();
                occ1 += ratio < 1 ? 1.0 : (double)ratio;
            }
            TextRulerRulePattern items2 = o2.getInFiller();
            items2.addAll(o2.getPostFiller());
            items2.addAll(o2.getPreFiller());
            for (TextRulerRuleItem each : items2) {
                KEPRuleItem eachItem = (KEPRuleItem)each;
                int ratio = KEPLearner.this.exampleDocuments.getAllPositiveExamples().size() / this.cas.getAnnotationIndex(eachItem.getType()).size();
                occ2 += ratio < 1 ? 1.0 : (double)ratio;
            }
            double v1 = occ1;
            double v2 = occ2;
            if (v1 > v2) {
                return 1;
            }
            if (v2 > v1) {
                return -1;
            }
            return 0;
        }
    }
}

