/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cpe.model;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.application.metadata.DeploymentOverrides;
import org.apache.uima.application.metadata.OverrideSet;
import org.apache.uima.application.metadata.UimaApplication;
import org.apache.uima.application.metadata.impl.AbstractUimaCasProcessor;
import org.apache.uima.application.metadata.impl.UimaApplication_Impl;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.cpe.model.ConfigParametersModel;
import org.apache.uima.cpe.model.CpeDescriptorModel;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UimaCollectionReader
extends AbstractUimaCasProcessor {
    private CpeCollectionReader cpeCollectionReader = null;
    private ResourceSpecifier specifier;

    public UimaCollectionReader() {
        super(1, null);
    }

    public UimaCollectionReader(UimaApplication app) {
        super(1, app);
    }

    public UimaCollectionReader(CpeDescriptorModel parentModel, CpeCollectionReader cpeCollReader, UimaApplication app) {
        super(1, app);
        this.cpeCollectionReader = cpeCollReader;
        this.xmlDescriptor = cpeCollReader.getDescriptor().getInclude().get();
        try {
            this.specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(this.xmlDescriptor));
            if (this.specifier instanceof CollectionReaderDescription) {
                ProcessingResourceMetaData m = ((CollectionReaderDescription)this.specifier).getCollectionReaderMetaData();
                this.configParamDecls = m.getConfigurationParameterDeclarations();
                this.configParamSettings = m.getConfigurationParameterSettings();
                this.configParamsModel = new ConfigParametersModel(this.configParamDecls, this.configParamSettings);
                this.setName(m.getName());
                this.setInstanceName(m.getName());
                this.setDescription(m.getDescription());
                UimaCollectionReader.createConfigParamOverrides(this.configParamsModel);
            } else {
                this.specifier = null;
            }
            this.xmlizableDescriptor = this.specifier;
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static UimaCollectionReader createUimaCasProcessor(CpeCollectionReader cpeCollReader_NOT_USED, String xmlDescriptor, UimaApplication app) {
        UimaCollectionReader u = new UimaCollectionReader(app);
        u.xmlDescriptor = xmlDescriptor;
        u.instanceName = "Unknown Collection Reader";
        try {
            String resolvedFileName = UimaApplication_Impl.resolveUimaXmlDescriptor(xmlDescriptor);
            if (resolvedFileName == null) {
                u.status = 2;
                u.statusDetails = 1;
                return u;
            }
            File f = new File(resolvedFileName);
            if (!f.exists()) {
                Trace.err("cannot find file: " + resolvedFileName);
                u.status = 2;
                u.statusDetails = 1;
                return u;
            }
            u.specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(resolvedFileName));
            if (u.specifier instanceof CollectionReaderDescription) {
                ProcessingResourceMetaData m = ((CollectionReaderDescription)u.specifier).getCollectionReaderMetaData();
                u.configParamDecls = m.getConfigurationParameterDeclarations();
                u.configParamSettings = m.getConfigurationParameterSettings();
                u.instanceName = m.getName();
                u.casProcessorDescription = m.getDescription();
                u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings, cpeCollReader_NOT_USED.getConfigurationParameterSettings());
                UimaCollectionReader.createConfigParamOverrides(u.configParamsModel);
            } else {
                Trace.err("Cannot parse CR xml: " + xmlDescriptor);
                u.specifier = null;
            }
            u.xmlizableDescriptor = u.specifier;
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        return u;
    }

    public static UimaCollectionReader createUimaCasProcessor(CollectionReaderDescription collReaderDescription_NOT_USED, String xmlDescriptor, UimaApplication app) {
        UimaCollectionReader u = new UimaCollectionReader(app);
        u.xmlDescriptor = xmlDescriptor;
        u.instanceName = "Unknown";
        try {
            u.specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(UimaApplication_Impl.resolveUimaXmlDescriptor(xmlDescriptor)));
            if (u.specifier instanceof CollectionReaderDescription) {
                ProcessingResourceMetaData m = ((CollectionReaderDescription)u.specifier).getCollectionReaderMetaData();
                u.configParamDecls = m.getConfigurationParameterDeclarations();
                u.configParamSettings = m.getConfigurationParameterSettings();
                u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings);
                u.instanceName = m.getName();
                u.casProcessorDescription = m.getDescription();
                UimaCollectionReader.createConfigParamOverrides(u.configParamsModel);
            } else {
                u.specifier = null;
            }
            u.xmlizableDescriptor = u.specifier;
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        return u;
    }

    protected static CollectionReaderDescription createCollectionReaderDescription(UimaCollectionReader u, String xmlDescriptor) {
        String resolvedFileName = UimaApplication_Impl.resolveUimaXmlDescriptor(xmlDescriptor);
        if (resolvedFileName == null) {
            u.status = 2;
            u.statusDetails = 1;
            return null;
        }
        File f = new File(resolvedFileName);
        if (!f.exists()) {
            Trace.err("cannot find file: " + resolvedFileName);
            u.status = 2;
            u.statusDetails = 1;
            return null;
        }
        try {
            u.specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(resolvedFileName));
            if (u.specifier instanceof CollectionReaderDescription) {
                ProcessingResourceMetaData m = ((CollectionReaderDescription)u.specifier).getCollectionReaderMetaData();
                u.configParamDecls = m.getConfigurationParameterDeclarations();
                u.configParamSettings = m.getConfigurationParameterSettings();
                u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings);
                u.instanceName = m.getName();
                u.casProcessorDescription = m.getDescription();
            } else {
                u.specifier = null;
            }
            u.xmlizableDescriptor = u.specifier;
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            u.specifier = null;
        }
        return (CollectionReaderDescription)u.specifier;
    }

    public ConfigurationParameterDeclarations getConfigurationParameterDeclarations() {
        return this.configParamDecls;
    }

    public ConfigurationParameterSettings getConfigurationParameterSettings() {
        return this.configParamSettings;
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        this.setInstanceName(aElement.getAttribute("name"));
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("import".equals(elem.getTagName())) {
                this.setXmlDescriptor(elem.getAttribute("location"));
                UimaCollectionReader.createCollectionReaderDescription(this, this.getXmlDescriptor());
                continue;
            }
            if ("deploymentOverrides".equals(elem.getTagName())) {
                this.setDeploymentOverrides((DeploymentOverrides)aParser.buildObject(elem, aOptions));
                continue;
            }
            if ("deploymentSettings".equals(elem.getTagName())) continue;
            Trace.err("Unknown Tag: " + elem.getTagName());
        }
        if (this.getConfigParamsModel() != null) {
            ConfigParametersModel models = this.getConfigParamsModel();
            OverrideSet[] sets = this.getDeploymentOverrides().getConfigParamOverrides().getOverrideSets();
            if (sets != null && sets[0].getConfigurationParameterSettings() != null) {
                NameValuePair[] pairs = sets[0].getConfigurationParameterSettings().getParameterSettings();
                if (pairs != null && pairs.length > 0) {
                    UimaCollectionReader.createConfigParamOverrides(models, sets[0].getConfigurationParameterSettings());
                } else {
                    Trace.err("EMPTY Overrides");
                }
            } else {
                Trace.err("NO Overrides");
            }
        }
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }
}

